/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center.wrappers;

import hudson.util.VersionNumber;
import io.jenkins.update_center.HPI;
import io.jenkins.update_center.JenkinsWar;
import io.jenkins.update_center.Plugin;
import io.jenkins.update_center.wrappers.MavenRepositoryWrapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class AllowedArtifactsListMavenRepository
extends MavenRepositoryWrapper {
    private static final Logger LOGGER = Logger.getLogger(AllowedArtifactsListMavenRepository.class.getName());
    private final Properties allowedArtifactsList;

    public AllowedArtifactsListMavenRepository(Properties allowedArtifactsList) {
        this.allowedArtifactsList = allowedArtifactsList;
    }

    @Override
    public Collection<Plugin> listJenkinsPlugins() throws IOException {
        Collection<Plugin> plugins = this.base.listJenkinsPlugins();
        Iterator<Plugin> pluginIterator = plugins.iterator();
        while (pluginIterator.hasNext()) {
            Plugin plugin = pluginIterator.next();
            String listEntry = this.allowedArtifactsList.getProperty(plugin.getArtifactId());
            if (listEntry == null) {
                pluginIterator.remove();
                continue;
            }
            if (listEntry.equals("*")) continue;
            List allowedVersions = Arrays.stream(listEntry.split("\\s+")).map(String::trim).collect(Collectors.toList());
            Iterator<Map.Entry<VersionNumber, HPI>> versionIterator = plugin.getArtifacts().entrySet().iterator();
            while (versionIterator.hasNext()) {
                Map.Entry<VersionNumber, HPI> entry = versionIterator.next();
                HPI hpi = entry.getValue();
                if (allowedVersions.contains(hpi.version)) continue;
                versionIterator.remove();
            }
            if (!plugin.getArtifacts().isEmpty()) continue;
            LOGGER.log(Level.WARNING, "Individual versions of a plugin are allowed, but none of them matched: " + plugin.getArtifactId() + " versions: " + listEntry);
            pluginIterator.remove();
        }
        return plugins;
    }

    @Override
    public TreeMap<VersionNumber, JenkinsWar> getJenkinsWarsByVersionNumber() throws IOException {
        String listEntry = this.allowedArtifactsList.getProperty("jenkins-core");
        if (listEntry == null) {
            return new TreeMap<VersionNumber, JenkinsWar>();
        }
        TreeMap<VersionNumber, JenkinsWar> releases = this.base.getJenkinsWarsByVersionNumber();
        if (listEntry.equals("*")) {
            return releases;
        }
        List allowedVersions = Arrays.stream(listEntry.split("\\s+")).map(String::trim).collect(Collectors.toList());
        releases.keySet().retainAll(releases.keySet().stream().filter(it -> allowedVersions.contains(it.toString())).collect(Collectors.toSet()));
        return releases;
    }
}

