/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public final class Environment {
    private static final Logger LOGGER = Logger.getLogger(Environment.class.getName());

    private Environment() {
    }

    public static String getString(@Nonnull String key, @CheckForNull String defaultValue) {
        String property = System.getProperty(key);
        if (property != null) {
            LOGGER.log(Level.CONFIG, "Found key: " + key + " in system properties: " + property);
            return property;
        }
        String env = System.getenv(key);
        if (env != null) {
            LOGGER.log(Level.CONFIG, "Found key: " + key + " in process environment: " + env);
            return env;
        }
        LOGGER.log(Level.CONFIG, "Failed to find key: " + key + " so using default: " + defaultValue);
        return defaultValue;
    }

    public static String getString(@Nonnull String key) {
        return Environment.getString(key, null);
    }

    public static int getInteger(@Nonnull String key) {
        return Environment.getInteger(key, 0);
    }

    public static int getInteger(@Nonnull String key, int defaultValue) {
        try {
            return Integer.parseInt(Environment.getString(key, Integer.toString(defaultValue)));
        }
        catch (NumberFormatException nfe) {
            LOGGER.log(Level.WARNING, nfe.getMessage(), nfe);
            return defaultValue;
        }
    }
}

