/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.SerializerFeature;
import io.jenkins.update_center.Signer;
import io.jenkins.update_center.json.JsonSignature;
import io.jenkins.update_center.util.Timestamp;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;

public abstract class WithSignature {
    private JsonSignature signature;

    @JSONField
    public JsonSignature getSignature() {
        return this.signature;
    }

    public String getGenerationTimestamp() {
        return Timestamp.TIMESTAMP;
    }

    private void writeWithSignature(Writer writer, Signer signer, boolean pretty) throws IOException, GeneralSecurityException {
        this.signature = null;
        String unsignedJson = JSON.toJSONString((Object)this, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        this.signature = signer.sign(unsignedJson);
        if (pretty) {
            JSON.writeJSONString((Writer)writer, (Object)this, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.PrettyFormat});
        } else {
            JSON.writeJSONString((Writer)writer, (Object)this, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        }
        writer.flush();
    }

    public void writeWithSignature(File outputFile, Signer signer, boolean pretty) throws IOException, GeneralSecurityException {
        try (OutputStream os = Files.newOutputStream(outputFile.toPath(), new OpenOption[0]);
             OutputStreamWriter writer = new OutputStreamWriter(os, StandardCharsets.UTF_8);){
            this.writeWithSignature(writer, signer, pretty);
        }
    }

    public String encodeWithSignature(Signer signer, boolean pretty) throws IOException, GeneralSecurityException {
        StringWriter writer = new StringWriter();
        this.writeWithSignature(writer, signer, pretty);
        return writer.getBuffer().toString();
    }
}

