/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center.json;

import com.alibaba.fastjson.annotation.JSONField;
import hudson.util.VersionNumber;
import io.jenkins.update_center.JenkinsWar;
import io.jenkins.update_center.MavenArtifact;
import io.jenkins.update_center.MavenRepository;
import io.jenkins.update_center.json.WithoutSignature;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class TieredUpdateSitesGenerator
extends WithoutSignature {
    private MavenRepository repository;
    @JSONField
    public List<String> weeklyCores;
    @JSONField
    public List<String> stableCores;
    public static final Logger LOGGER = Logger.getLogger(TieredUpdateSitesGenerator.class.getName());
    private static final int CORE_AGE_DAYS = 400;

    public TieredUpdateSitesGenerator withRepository(MavenRepository repository) throws IOException {
        this.repository = repository;
        this.update();
        return this;
    }

    private static boolean isStableVersion(VersionNumber version) {
        return version.getDigitAt(2) != -1;
    }

    private static VersionNumber nextWeeklyReleaseAfterStableBaseline(VersionNumber version) {
        if (!version.toString().matches("[0-9][.][0-9]+[.][1-9]")) {
            throw new IllegalArgumentException("Unexpected LTS version: " + version.toString());
        }
        return new VersionNumber(version.getDigitAt(0) + "." + (version.getDigitAt(1) + 1));
    }

    private VersionNumber nextLtsReleaseAfterWeekly(VersionNumber dependencyVersion, Set<VersionNumber> keySet) {
        return keySet.stream().filter(TieredUpdateSitesGenerator::isStableVersion).sorted().filter(v -> v.isNewerThan(dependencyVersion)).findFirst().orElse(null);
    }

    private static boolean isReleaseRecentEnough(JenkinsWar war) throws IOException {
        Objects.requireNonNull(war, "war");
        return war.getTimestampAsDate().toInstant().isAfter(Instant.now().minus(400L, ChronoUnit.DAYS));
    }

    public void update() throws IOException {
        Collection allPluginReleases = this.repository.listJenkinsPlugins().stream().map(plugin -> plugin.getArtifacts().values()).reduce(new HashSet(), (acc, els) -> {
            acc.addAll(els);
            return acc;
        });
        List coreDependencyVersions = allPluginReleases.stream().map(v -> {
            try {
                return v.getRequiredJenkinsVersion();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to determine required Jenkins version for " + v.getGavId(), e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet()).stream().map(VersionNumber::new).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        TreeMap<VersionNumber, JenkinsWar> allJenkinsWarsByVersionNumber = this.repository.getJenkinsWarsByVersionNumber();
        HashSet<VersionNumber> weeklyCores = new HashSet<VersionNumber>();
        HashSet<VersionNumber> stableCores = new HashSet<VersionNumber>();
        boolean stableDone = false;
        boolean weeklyDone = false;
        for (VersionNumber dependencyVersion : coreDependencyVersions) {
            JenkinsWar war = allJenkinsWarsByVersionNumber.get(dependencyVersion);
            if (war == null) {
                LOGGER.log(Level.INFO, "Did not find declared core dependency version among all core releases: " + dependencyVersion.toString() + ". It is used by " + allPluginReleases.stream().filter(p -> {
                    try {
                        return p.getRequiredJenkinsVersion().equals(dependencyVersion.toString());
                    }
                    catch (IOException e) {
                        return false;
                    }
                }).map(MavenArtifact::getGavId).collect(Collectors.joining(", ")));
                continue;
            }
            boolean releaseRecentEnough = TieredUpdateSitesGenerator.isReleaseRecentEnough(war);
            if (TieredUpdateSitesGenerator.isStableVersion(dependencyVersion)) {
                if (!stableDone) {
                    if (!releaseRecentEnough) {
                        stableDone = true;
                    }
                    stableCores.add(dependencyVersion);
                    if (!weeklyDone) {
                        weeklyCores.add(TieredUpdateSitesGenerator.nextWeeklyReleaseAfterStableBaseline(dependencyVersion));
                    }
                }
            } else {
                VersionNumber v2;
                if (!weeklyDone) {
                    if (!releaseRecentEnough) {
                        weeklyDone = true;
                    }
                    weeklyCores.add(dependencyVersion);
                }
                if (!stableDone && (v2 = this.nextLtsReleaseAfterWeekly(dependencyVersion, allJenkinsWarsByVersionNumber.keySet())) != null) {
                    stableCores.add(v2);
                }
            }
            if (!stableDone || !weeklyDone) continue;
            break;
        }
        this.stableCores = stableCores.stream().map(VersionNumber::toString).sorted().collect(Collectors.toList());
        this.weeklyCores = weeklyCores.stream().map(VersionNumber::toString).sorted().collect(Collectors.toList());
    }
}

