/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center.json;

import com.alibaba.fastjson.annotation.JSONField;
import io.jenkins.update_center.HPI;
import io.jenkins.update_center.MavenArtifact;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;

class ReleaseHistoryEntry {
    @JSONField
    public final String title;
    @JSONField
    public final String wiki;
    @JSONField
    public final String gav;
    @JSONField
    public final String version;
    @JSONField
    public final long timestamp;
    @JSONField
    public final String url;
    @JSONField
    public Boolean latestRelease;
    @JSONField
    public Boolean firstRelease;
    private static final Calendar DATE_CUTOFF = new GregorianCalendar();

    ReleaseHistoryEntry(HPI hpi) throws IOException {
        if (hpi.getTimestampAsDate().after(DATE_CUTOFF.getTime())) {
            this.title = hpi.getName();
            this.wiki = hpi.getPluginUrl();
        } else {
            this.title = null;
            this.wiki = null;
        }
        if (hpi.getPlugin().getLatest() == hpi) {
            this.latestRelease = true;
        }
        if (hpi.getPlugin().getFirst() == hpi) {
            this.firstRelease = true;
        }
        this.version = hpi.version;
        this.gav = hpi.artifact.getGav();
        this.timestamp = hpi.repository.getMetadata((MavenArtifact)hpi).timestamp;
        this.url = "https://plugins.jenkins.io/" + hpi.artifact.artifactId;
    }

    static {
        DATE_CUTOFF.add(5, -31);
    }
}

