/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center.json;

import com.alibaba.fastjson.annotation.JSONField;
import io.jenkins.update_center.HPI;
import io.jenkins.update_center.MavenRepository;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;

public class PluginVersionsEntry {
    @JSONField
    public final String buildDate;
    @JSONField
    public final String name;
    @JSONField
    public final String requiredCore;
    @JSONField
    public final String sha1;
    @JSONField
    public final String sha256;
    @JSONField
    public final String url;
    @JSONField
    public final String version;
    @JSONField
    public final String compatibleSinceVersion;
    @JSONField
    public final String releaseTimestamp;
    @JSONField
    public final List<HPI.Dependency> dependencies;
    private static final SimpleDateFormat TIMESTAMP_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.00Z'", Locale.US);

    PluginVersionsEntry(HPI hpi) throws IOException {
        MavenRepository.ArtifactMetadata artifactMetadata = hpi.getMetadata();
        this.name = hpi.artifact.artifactId;
        this.requiredCore = hpi.getRequiredJenkinsVersion();
        this.sha1 = artifactMetadata.sha1;
        this.sha256 = artifactMetadata.sha256;
        this.url = hpi.getDownloadUrl().toString();
        this.version = hpi.version;
        this.buildDate = hpi.getTimestampAsString();
        this.dependencies = hpi.getDependencies();
        this.compatibleSinceVersion = hpi.getCompatibleSinceVersion();
        this.releaseTimestamp = TIMESTAMP_FORMATTER.format(hpi.getTimestamp());
    }
}

