/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center.json;

import com.alibaba.fastjson.annotation.JSONField;
import hudson.util.VersionNumber;
import io.jenkins.update_center.HPI;
import io.jenkins.update_center.json.PluginVersionsEntry;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class PluginVersions {
    private static final Logger LOGGER = Logger.getLogger(PluginVersions.class.getName());
    @JSONField(unwrapped=true)
    public Map<String, PluginVersionsEntry> releases = new LinkedHashMap<String, PluginVersionsEntry>();

    PluginVersions(Map<VersionNumber, HPI> artifacts) {
        for (VersionNumber versionNumber : artifacts.keySet().stream().sorted().collect(Collectors.toList())) {
            try {
                if (this.releases.put(versionNumber.toString(), new PluginVersionsEntry(artifacts.get(versionNumber))) == null) continue;
                throw new IllegalStateException("Duplicate key");
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "Failed to add " + artifacts.get((Object)versionNumber).artifact.getGav() + " to plugin versions", ex);
            }
        }
    }
}

