/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center;

import io.jenkins.update_center.json.JsonSignature;
import io.jenkins.update_center.util.Environment;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.TeeOutputStream;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.jvnet.hudson.crypto.CertificateUtil;
import org.jvnet.hudson.crypto.SignatureOutputStream;
import org.kohsuke.args4j.Option;

public class Signer {
    private static final Logger LOGGER = Logger.getLogger(Signer.class.getName());
    @Option(name="--key", usage="Private key to sign the update center. Must be used in conjunction with -certificate.")
    public File privateKey = null;
    @Option(name="--certificate", usage="X509 certificate for the private key given by the -key option. Specify additional -certificate options to pass in intermediate certificates, if any. These certificates will be part of update site metadata.")
    public List<File> certificates;
    @Option(name="--root-certificate", usage="Additional root certificates for use in validation. These certificates will not be part of update site metadata.")
    public List<File> rootCA;
    private static final int MINIMUM_VALIDITY_DURATION = Environment.getInteger("CERTIFICATE_MINIMUM_VALID_DAYS", 30);

    public boolean isConfigured() {
        if (this.privateKey != null && this.certificates != null && !this.certificates.isEmpty()) {
            return true;
        }
        if (this.privateKey != null || this.certificates != null && !this.certificates.isEmpty()) {
            throw new IllegalStateException("Both -key and -certificate must be specified");
        }
        return false;
    }

    public JsonSignature sign(String json) throws GeneralSecurityException, IOException {
        PrivateKey key;
        X509Certificate signer;
        List<X509Certificate> certs;
        JsonSignature sign;
        block14: {
            if (!this.isConfigured()) {
                return null;
            }
            sign = new JsonSignature();
            certs = this.getCertificateChain();
            signer = certs.get(0);
            try (PEMParser pem = new PEMParser((Reader)Files.newBufferedReader(this.privateKey.toPath(), StandardCharsets.UTF_8));){
                Object o = pem.readObject();
                if (o instanceof PrivateKeyInfo) {
                    PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)o;
                    key = new JcaPEMKeyConverter().getPrivateKey(privateKeyInfo);
                    break block14;
                }
                if (o instanceof PEMKeyPair) {
                    PEMKeyPair pemKeyPair = (PEMKeyPair)o;
                    key = new JcaPEMKeyConverter().getKeyPair(pemKeyPair).getPrivate();
                    break block14;
                }
                throw new IllegalArgumentException("Unexpected type for private key: " + o.getClass().getName());
            }
        }
        SignatureGenerator sg = new SignatureGenerator(signer, key);
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)sg.out, StandardCharsets.UTF_8);){
            IOUtils.write((String)json, (Writer)osw);
        }
        sg.fill(sign);
        ArrayList<String> certificates = new ArrayList<String>();
        for (X509Certificate cert : certs) {
            certificates.add(new String(Base64.encodeBase64((byte[])cert.getEncoded()), StandardCharsets.UTF_8));
        }
        sign.setCertificates(certificates);
        return sign;
    }

    private List<X509Certificate> getCertificateChain() throws IOException, GeneralSecurityException {
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        if (this.certificates != null) {
            for (File file : this.certificates) {
                X509Certificate c = this.loadCertificate(cf, file);
                c.checkValidity(new Date(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(MINIMUM_VALIDITY_DURATION)));
                if (certs.isEmpty()) {
                    LOGGER.log(Level.INFO, () -> "Update site certificate: Subject: " + String.valueOf(c.getSubjectDN()) + " Issuer: " + String.valueOf(c.getIssuerDN()) + " NotBefore: " + String.valueOf(c.getNotBefore()) + " NotAfter: " + String.valueOf(c.getNotAfter()));
                }
                certs.add(c);
            }
        }
        for (X509Certificate x509Certificate : certs) {
            LOGGER.log(Level.CONFIG, "Certificate: " + String.valueOf(x509Certificate));
        }
        HashSet<TrustAnchor> rootCAs = new HashSet<TrustAnchor>();
        if (this.rootCA != null) {
            for (File f : this.rootCA) {
                rootCAs.add(new TrustAnchor(this.loadCertificate(cf, f), null));
            }
        }
        for (TrustAnchor anchor : rootCAs) {
            LOGGER.log(Level.CONFIG, "Trust anchor: " + String.valueOf(anchor));
        }
        if (this.rootCA == null || this.rootCA.size() == 0) {
            LOGGER.log(Level.WARNING, "No root CA specified, skipping path validation");
        } else {
            try {
                CertificateUtil.validatePath(certs, rootCAs);
            }
            catch (GeneralSecurityException generalSecurityException) {
                LOGGER.log(Level.WARNING, "Failed path validation", generalSecurityException);
            }
        }
        return certs;
    }

    private X509Certificate loadCertificate(CertificateFactory cf, File f) throws IOException {
        X509Certificate x509Certificate;
        FileInputStream in = new FileInputStream(f);
        try {
            X509Certificate c = (X509Certificate)cf.generateCertificate(in);
            c.checkValidity();
            x509Certificate = c;
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | CertificateException e) {
                throw (IOException)new IOException("Failed to load certificate " + String.valueOf(f)).initCause(e);
            }
        }
        in.close();
        return x509Certificate;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    static class SignatureGenerator {
        private final MessageDigest sha1 = DigestUtils.getSha1Digest();
        private final Signature sha1sig;
        private final MessageDigest sha512 = DigestUtils.getSha512Digest();
        private final Signature sha512sig;
        private final TeeOutputStream out;
        private final Signature verifier1;
        private final Signature verifier512;

        SignatureGenerator(X509Certificate signer, PrivateKey key) throws GeneralSecurityException {
            DigestOutputStream dos1 = new DigestOutputStream((OutputStream)new NullOutputStream(), this.sha1);
            DigestOutputStream dos512 = new DigestOutputStream((OutputStream)new NullOutputStream(), this.sha512);
            this.sha1sig = Signature.getInstance("SHA1withRSA");
            this.sha1sig.initSign(key);
            SignatureOutputStream sos1 = new SignatureOutputStream(this.sha1sig);
            this.sha512sig = Signature.getInstance("SHA512withRSA");
            this.sha512sig.initSign(key);
            SignatureOutputStream sos512 = new SignatureOutputStream(this.sha512sig);
            this.verifier1 = Signature.getInstance("SHA1withRSA");
            this.verifier1.initVerify(signer.getPublicKey());
            SignatureOutputStream vos1 = new SignatureOutputStream(this.verifier1);
            this.verifier512 = Signature.getInstance("SHA512withRSA");
            this.verifier512.initVerify(signer.getPublicKey());
            SignatureOutputStream vos512 = new SignatureOutputStream(this.verifier512);
            this.out = new TeeOutputStream((OutputStream)new TeeOutputStream((OutputStream)new TeeOutputStream((OutputStream)new TeeOutputStream((OutputStream)new TeeOutputStream((OutputStream)dos1, (OutputStream)sos1), (OutputStream)vos1), (OutputStream)dos512), (OutputStream)sos512), (OutputStream)vos512);
        }

        public TeeOutputStream getOut() {
            return this.out;
        }

        private void fill(JsonSignature signature) throws GeneralSecurityException {
            byte[] digest = this.sha1.digest();
            signature.setDigest(new String(Base64.encodeBase64((byte[])digest), StandardCharsets.UTF_8));
            signature.setDigest512(Hex.encodeHexString((byte[])this.sha512.digest()));
            byte[] s1 = this.sha1sig.sign();
            byte[] s512 = this.sha512sig.sign();
            signature.setSignature(new String(Base64.encodeBase64((byte[])s1), StandardCharsets.UTF_8));
            signature.setSignature512(Hex.encodeHexString((byte[])s512));
            if (!this.verifier1.verify(s1)) {
                throw new GeneralSecurityException("Signature (SHA-1) failed to validate. Either the certificate and the private key weren't matching, or a bug in the program.");
            }
            if (!this.verifier512.verify(s512)) {
                throw new GeneralSecurityException("Signature (SHA-512) failed to validate. Either the certificate and the private key weren't matching, or a bug in the program.");
            }
        }
    }
}

