/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Popularities {
    private static final String JSON_URL = "https://raw.githubusercontent.com/jenkins-infra/infra-statistics/gh-pages/plugin-installation-trend/latestNumbers.json";
    private static Popularities instance;
    private final Map<String, Integer> popularities;

    private Popularities(Map<String, Integer> popularities) {
        this.popularities = popularities;
    }

    private static void initialize() throws IOException {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(JSON_URL)).GET().build();
        try (HttpClient client = HttpClient.newHttpClient();){
            HttpResponse<String> httpResp = client.send(request, HttpResponse.BodyHandlers.ofString());
            JsonResponse response = (JsonResponse)JSON.parseObject((String)httpResp.body(), JsonResponse.class);
            if (response.plugins == null) {
                throw new IllegalArgumentException("Specified popularity URL 'https://raw.githubusercontent.com/jenkins-infra/infra-statistics/gh-pages/plugin-installation-trend/latestNumbers.json' does not contain a JSON object 'plugins'");
            }
            Map<String, Integer> popularities = response.plugins.keySet().stream().collect(Collectors.toMap(Function.identity(), value -> Integer.valueOf(response.plugins.get(value))));
            instance = new Popularities(popularities);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public static synchronized Popularities getInstance() throws IOException {
        if (instance == null) {
            Popularities.initialize();
        }
        return instance;
    }

    public int getPopularity(String pluginId) {
        return this.popularities.getOrDefault(pluginId, 0);
    }

    private static class JsonResponse {
        public Map<String, String> plugins;

        private JsonResponse() {
        }
    }
}

