/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center;

import com.alibaba.fastjson.annotation.JSONField;
import hudson.util.VersionNumber;
import io.jenkins.update_center.HPI;
import io.jenkins.update_center.HealthScores;
import io.jenkins.update_center.IssueTrackerSource;
import io.jenkins.update_center.LatestPluginVersions;
import io.jenkins.update_center.MaintainersSource;
import io.jenkins.update_center.Plugin;
import io.jenkins.update_center.Popularities;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;

public class PluginUpdateCenterEntry {
    @JSONField(name="name")
    public final String artifactId;
    private final transient HPI latestOffered;
    @CheckForNull
    private final transient HPI previousOffered;
    private static final SimpleDateFormat TIMESTAMP_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.00Z'", Locale.US);
    private static final Logger LOGGER = Logger.getLogger(PluginUpdateCenterEntry.class.getName());

    private PluginUpdateCenterEntry(String artifactId, HPI latestOffered, HPI previousOffered) {
        this.artifactId = artifactId;
        this.latestOffered = latestOffered;
        this.previousOffered = previousOffered;
    }

    public PluginUpdateCenterEntry(Plugin plugin) throws IOException {
        HPI h;
        this.artifactId = plugin.getArtifactId();
        HPI previous = null;
        HPI latest = null;
        Iterator<HPI> it = plugin.getArtifacts().values().iterator();
        while (latest == null && it.hasNext()) {
            h = it.next();
            try {
                h.validate();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to resolve " + String.valueOf(h) + ". Dropping this version.", e);
                continue;
            }
            latest = h;
        }
        while (previous == null && it.hasNext()) {
            h = it.next();
            try {
                h.validate();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to resolve " + String.valueOf(h) + ". Dropping this version.", e);
                continue;
            }
            previous = h;
        }
        if (latest == null) {
            throw new IOException("Plugin '" + this.artifactId + "' has no valid release");
        }
        this.latestOffered = latest;
        this.previousOffered = previous == latest ? null : previous;
    }

    public PluginUpdateCenterEntry(HPI hpi) {
        this(hpi.artifact.artifactId, hpi, null);
    }

    @JSONField
    public String getWiki() {
        return "https://plugins.jenkins.io/" + this.artifactId;
    }

    String getPluginUrl() throws IOException {
        return this.latestOffered.getPluginUrl();
    }

    @JSONField(name="url")
    public URL getDownloadUrl() throws MalformedURLException {
        return this.latestOffered.getDownloadUrl();
    }

    @JSONField(name="title")
    public String getName() throws IOException {
        return this.latestOffered.getName();
    }

    public String getVersion() {
        return this.latestOffered.version;
    }

    public String getPreviousVersion() {
        return this.previousOffered == null ? null : this.previousOffered.version;
    }

    public String getScm() throws IOException {
        return this.latestOffered.getScmUrl();
    }

    public List<IssueTrackerSource.IssueTracker> getIssueTrackers() {
        return IssueTrackerSource.getInstance().getIssueTrackers(this.artifactId);
    }

    public String getRequiredCore() throws IOException {
        return this.latestOffered.getRequiredJenkinsVersion();
    }

    public String getCompatibleSinceVersion() throws IOException {
        return this.latestOffered.getCompatibleSinceVersion();
    }

    public String getBuildDate() throws IOException {
        return this.latestOffered.getTimestampAsString();
    }

    public List<String> getLabels() throws IOException {
        ArrayList<String> labels = new ArrayList<String>(this.latestOffered.getLabels());
        if (this.getDevelopers().isEmpty() && !labels.contains("adopt-this-plugin")) {
            LOGGER.log(Level.INFO, () -> "Adding 'adopt-this-plugin' label to " + this.artifactId + " due to lack of maintainers");
            labels.add("adopt-this-plugin");
        }
        return labels;
    }

    public String getDefaultBranch() throws IOException {
        return this.latestOffered.getDefaultBranch();
    }

    public List<HPI.Dependency> getDependencies() throws IOException {
        return this.latestOffered.getDependencies();
    }

    public String getSha1() throws IOException {
        return this.latestOffered.getMetadata().sha1;
    }

    public String getSha256() throws IOException {
        return this.latestOffered.getMetadata().sha256;
    }

    public long getSize() throws IOException {
        return this.latestOffered.getMetadata().size;
    }

    public String getGav() {
        return this.latestOffered.getGavId();
    }

    public List<MaintainersSource.Maintainer> getDevelopers() {
        return MaintainersSource.getInstance().getMaintainers(this.latestOffered.artifact);
    }

    public String getExcerpt() throws IOException {
        return this.latestOffered.getDescription();
    }

    public String getReleaseTimestamp() throws IOException {
        return TIMESTAMP_FORMATTER.format(this.latestOffered.getTimestamp());
    }

    public String getPreviousTimestamp() throws IOException {
        return this.previousOffered == null ? null : TIMESTAMP_FORMATTER.format(this.previousOffered.getTimestamp());
    }

    public int getPopularity() throws IOException {
        return Popularities.getInstance().getPopularity(this.artifactId);
    }

    public Integer getHealth() {
        return HealthScores.getInstance().getHealthScore(this.artifactId);
    }

    public String getLatest() {
        LatestPluginVersions instance = LatestPluginVersions.getInstance();
        VersionNumber latestPublishedVersion = instance.getLatestVersion(this.artifactId);
        if (latestPublishedVersion == null || latestPublishedVersion.equals((Object)this.latestOffered.getVersion())) {
            return null;
        }
        return latestPublishedVersion.toString();
    }
}

