/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center;

import hudson.util.VersionNumber;
import io.jenkins.update_center.HPI;
import java.io.IOException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Plugin {
    private static final Logger LOGGER = Logger.getLogger(Plugin.class.getName());
    private final String artifactId;
    private final TreeMap<VersionNumber, HPI> artifacts = new TreeMap(VersionNumber.DESCENDING);
    private final Set<VersionNumber> duplicateVersions = new TreeSet<VersionNumber>();

    public Plugin(String shortName) {
        this.artifactId = shortName;
    }

    public HPI getLatest() {
        return this.artifacts.get(this.artifacts.firstKey());
    }

    public HPI getFirst() {
        return this.artifacts.get(this.artifacts.lastKey());
    }

    public void addArtifact(HPI hpi) throws IOException {
        VersionNumber v;
        try {
            v = new VersionNumber(hpi.version);
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.WARNING, "Failed to parse version number " + hpi.version + " for " + String.valueOf(hpi));
            return;
        }
        if (this.duplicateVersions.contains(v)) {
            if (hpi.getTimestamp() > 0L) {
                this.artifacts.put(v, hpi);
                return;
            }
            LOGGER.log(Level.INFO, "Found another duplicate artifact " + hpi.artifact.getGav() + " considered identical due to non-determinism. Neither has a timestamp. Neither will be published.");
            return;
        }
        HPI existing = this.artifacts.get(v);
        if (existing == null) {
            this.artifacts.put(v, hpi);
            return;
        }
        if (existing.getTimestamp() > 0L) {
            if (hpi.getTimestamp() > 0L) {
                if (existing.getTimestamp() > hpi.getTimestamp()) {
                    LOGGER.log(Level.INFO, "The proposed artifact: " + hpi.artifact.getGav() + " is older than the existing artifact " + existing.artifact.getGav() + ", so replace it.");
                    this.artifacts.put(v, hpi);
                } else {
                    LOGGER.log(Level.INFO, "The proposed artifact: " + hpi.artifact.getGav() + " is not older than the existing artifact " + existing.artifact.getGav() + ", so ignore it.");
                }
            } else {
                LOGGER.log(Level.INFO, "The proposed artifact: " + hpi.artifact.getGav() + " has no timestamp (but the existing artifact " + hpi.artifact.getGav() + " does), so ignore it.");
            }
        } else if (hpi.getTimestamp() > 0L) {
            LOGGER.log(Level.INFO, "The proposed artifact: " + hpi.artifact.getGav() + " has a timestamp and the existing artifact " + existing.artifact.getGav() + " does not, so replace it.");
            this.artifacts.put(v, hpi);
        } else {
            LOGGER.log(Level.INFO, "Found a duplicate artifact " + hpi.artifact.getGav() + " (proposed) considered identical to " + existing.artifact.getGav() + " (existing) due to non-determinism. Neither has a timestamp. Neither will be published.");
            this.artifacts.remove(v);
            this.duplicateVersions.add(v);
        }
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public TreeMap<VersionNumber, HPI> getArtifacts() {
        return this.artifacts;
    }

    public String toString() {
        return "Plugin '" + this.artifactId + "'";
    }
}

