/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center;

import hudson.util.VersionNumber;
import io.jenkins.update_center.JenkinsWar;
import io.jenkins.update_center.MavenRepository;
import io.jenkins.update_center.util.Timestamp;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.kohsuke.args4j.Option;

public class MetadataWriter {
    private static final Logger LOGGER = Logger.getLogger(MetadataWriter.class.getName());
    private static final String LATEST_CORE_FILENAME = "latestCore.txt";
    private static final String PLUGIN_COUNT_FILENAME = "pluginCount.txt";
    private static final String TIMESTAMP_FILENAME = "timestamp.txt";
    @Option(name="--write-plugin-count", usage="Report the number of plugins published by the update site")
    public boolean generatePluginCount;
    @Option(name="--write-latest-core", usage="Generate a text file with the core version offered by this update site")
    public boolean generateLatestCore;
    @Option(name="--write-timestamp", usage="Generate a text file with the generation timestamp of this update site")
    public boolean generateTimestamp;

    public void writeMetadataFiles(@Nonnull MavenRepository repository, @CheckForNull File outputDirectory) throws IOException {
        FileOutputStream output;
        Objects.requireNonNull(repository, "repository");
        if (!(this.generateLatestCore || this.generatePluginCount || this.generateTimestamp)) {
            LOGGER.log(Level.INFO, "Skipping generation of metadata files");
            return;
        }
        if (outputDirectory == null) {
            throw new IOException("No output directory specified but generation of metadata files requested");
        }
        if (!outputDirectory.isDirectory() && !outputDirectory.mkdirs()) {
            throw new IOException("Failed to create " + String.valueOf(outputDirectory));
        }
        if (this.generateLatestCore) {
            TreeMap<VersionNumber, JenkinsWar> wars = repository.getJenkinsWarsByVersionNumber();
            if (wars.isEmpty()) {
                LOGGER.log(Level.WARNING, () -> "Cannot write latestCore.txt because there are no core versions in this update site");
            } else {
                try (FileOutputStream output2 = new FileOutputStream(new File(outputDirectory, LATEST_CORE_FILENAME));){
                    IOUtils.write((String)wars.firstKey().toString(), (OutputStream)output2, (Charset)StandardCharsets.UTF_8);
                }
            }
        }
        if (this.generatePluginCount) {
            output = new FileOutputStream(new File(outputDirectory, PLUGIN_COUNT_FILENAME));
            try {
                IOUtils.write((String)Integer.toString(repository.listJenkinsPlugins().size()), (OutputStream)output, (Charset)StandardCharsets.UTF_8);
            }
            finally {
                output.close();
            }
        }
        if (this.generateTimestamp) {
            output = new FileOutputStream(new File(outputDirectory, TIMESTAMP_FILENAME));
            try {
                IOUtils.write((String)Timestamp.TIMESTAMP, (OutputStream)output, (Charset)StandardCharsets.UTF_8);
            }
            finally {
                output.close();
            }
        }
    }
}

