/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center;

import hudson.util.VersionNumber;
import io.jenkins.update_center.ArtifactCoordinates;
import io.jenkins.update_center.HPI;
import io.jenkins.update_center.JenkinsWar;
import io.jenkins.update_center.MavenArtifact;
import io.jenkins.update_center.Plugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface MavenRepository {
    public static final Logger LOGGER = Logger.getLogger(MavenRepository.class.getName());

    public Collection<Plugin> listJenkinsPlugins() throws IOException;

    public TreeMap<VersionNumber, JenkinsWar> getJenkinsWarsByVersionNumber() throws IOException;

    public void addWarsInGroupIdToMap(Map<VersionNumber, JenkinsWar> var1, String var2, VersionNumber var3) throws IOException;

    public Collection<ArtifactCoordinates> listAllPlugins() throws IOException;

    public ArtifactMetadata getMetadata(MavenArtifact var1) throws IOException;

    public Manifest getManifest(MavenArtifact var1) throws IOException;

    public InputStream getZipFileEntry(MavenArtifact var1, String var2) throws IOException;

    public File resolve(ArtifactCoordinates var1) throws IOException;

    default public File resolve(ArtifactCoordinates a, String packaging, String classifier) throws IOException {
        return this.resolve(new ArtifactCoordinates(a.groupId, a.artifactId, a.version, packaging));
    }

    default public Map<Date, Map<String, HPI>> listPluginsByReleaseDate() throws IOException {
        Collection<Plugin> all = this.listJenkinsPlugins();
        TreeMap<Date, Map<String, HPI>> plugins = new TreeMap<Date, Map<String, HPI>>();
        for (Plugin plugin : all) {
            for (HPI hpi : plugin.getArtifacts().values()) {
                Date releaseDate = hpi.getTimestampAsDate();
                LOGGER.log(Level.FINE, "adding " + hpi.artifact.artifactId + ":" + hpi.version);
                Map pluginsOnDate = plugins.computeIfAbsent(releaseDate, k -> new TreeMap());
                pluginsOnDate.put(plugin.getArtifactId(), hpi);
            }
        }
        return plugins;
    }

    public static class ArtifactMetadata {
        public String sha1;
        public String sha256;
        public long timestamp;
        public long size;
    }
}

