/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center;

import hudson.util.VersionNumber;
import io.jenkins.update_center.ArtifactCoordinates;
import io.jenkins.update_center.BaseMavenRepository;
import io.jenkins.update_center.MavenRepository;
import io.jenkins.update_center.util.Environment;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.annotation.Nonnull;

public class MavenArtifact {
    protected static final String DOWNLOADS_ROOT_URL = Environment.getString("DOWNLOADS_ROOT_URL", "https://updates.jenkins.io/download");
    public final BaseMavenRepository repository;
    public final ArtifactCoordinates artifact;
    public final String version;
    private File hpi;
    private Manifest manifest;

    public MavenArtifact(@Nonnull BaseMavenRepository repository, @Nonnull ArtifactCoordinates artifact) {
        this.artifact = artifact;
        this.repository = repository;
        this.version = artifact.version;
    }

    public File resolve() throws IOException {
        try {
            if (this.hpi == null) {
                this.hpi = this.repository.resolve(this.artifact);
            }
            return this.hpi;
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Failed to resolve artifact " + String.valueOf(this.artifact), e);
        }
    }

    public File resolvePOM() throws IOException {
        return this.repository.resolve(this.artifact, "pom", null);
    }

    public MavenRepository.ArtifactMetadata getMetadata() throws IOException {
        return this.repository.getMetadata(this);
    }

    public VersionNumber getVersion() {
        return new VersionNumber(this.version);
    }

    public boolean isAlphaOrBeta() {
        String s = this.version.toLowerCase(Locale.ENGLISH);
        return s.contains("alpha") || s.contains("beta");
    }

    public String getTimestampAsString() throws IOException {
        long lastModified = this.getTimestamp();
        SimpleDateFormat bdf = MavenArtifact.getDateFormat();
        return bdf.format(lastModified);
    }

    public Date getTimestampAsDate() throws IOException {
        long lastModified = this.getTimestamp();
        Date lastModifiedDate = new Date(lastModified);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(lastModifiedDate);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static SimpleDateFormat getDateFormat() {
        return new SimpleDateFormat("MMM dd, yyyy", Locale.US);
    }

    public long getTimestamp() throws IOException {
        return this.repository.getMetadata((MavenArtifact)this).timestamp;
    }

    public Manifest getManifest() throws IOException {
        if (this.manifest == null) {
            this.manifest = this.repository.getManifest(this);
        }
        return this.manifest;
    }

    public Attributes getManifestAttributes() throws IOException {
        return this.getManifest().getMainAttributes();
    }

    public URL getDownloadUrl() throws MalformedURLException {
        return new URL("repo.jenkins-ci.org/public/" + this.artifact.groupId.replace('.', '/') + "/" + this.artifact.artifactId + "/" + this.artifact.version + "/" + this.artifact.artifactId + "-" + this.artifact.version + "." + this.artifact.packaging);
    }

    public String toString() {
        return this.artifact.toString();
    }

    public String getGavId() {
        return this.artifact.groupId + ":" + this.artifact.artifactId + ":" + this.artifact.version;
    }
}

