/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.Feature;
import io.jenkins.update_center.ArtifactCoordinates;
import io.jenkins.update_center.util.Environment;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;

public class MaintainersSource {
    private static final Logger LOGGER = Logger.getLogger(MaintainersSource.class.getName());
    private static final String PLUGIN_MAINTAINERS_DATA_URL = Environment.getString("PLUGIN_MAINTAINERS_DATA_URL", "https://reports.jenkins.io/maintainers.index.json");
    private static final String MAINTAINERS_INFO_URL = Environment.getString("MAINTAINERS_INFO_URL", "https://reports.jenkins.io/maintainers-info-report.json");
    private Map<String, List<String>> pluginToMaintainers;
    private Map<String, Maintainer> maintainerInfo;
    private static MaintainersSource instance;

    public static synchronized MaintainersSource getInstance() {
        if (instance == null) {
            MaintainersSource ms = new MaintainersSource();
            ms.init();
            instance = ms;
        }
        return instance;
    }

    private void init() {
        String jsonData;
        try {
            jsonData = IOUtils.toString((URL)new URL(MAINTAINERS_INFO_URL), (Charset)StandardCharsets.UTF_8);
            List rawMaintainersInfo = (List)JSON.parseObject((String)jsonData, (Type)new TypeReferenceForListOfJsonMaintainer().getType(), (Feature[])new Feature[0]);
            this.maintainerInfo = new HashMap<String, Maintainer>();
            rawMaintainersInfo.forEach(m -> {
                if (this.maintainerInfo.containsKey(m.name)) {
                    LOGGER.warning("Duplicate entry for " + m.name + " in " + MAINTAINERS_INFO_URL);
                }
                this.maintainerInfo.put(m.name, m.toMaintainer());
            });
        }
        catch (IOException | RuntimeException ex) {
            LOGGER.log(Level.WARNING, "Failed to process " + MAINTAINERS_INFO_URL, ex);
            this.maintainerInfo = new HashMap<String, Maintainer>();
        }
        try {
            jsonData = IOUtils.toString((URL)new URL(PLUGIN_MAINTAINERS_DATA_URL), (Charset)StandardCharsets.UTF_8);
            this.pluginToMaintainers = (Map)JSON.parseObject((String)jsonData, (Type)new TypeReferenceForHashMapFromStringToListOfString().getType(), (Feature[])new Feature[0]);
        }
        catch (IOException | RuntimeException ex) {
            this.pluginToMaintainers = new HashMap<String, List<String>>();
            LOGGER.log(Level.WARNING, "Failed to process" + PLUGIN_MAINTAINERS_DATA_URL, ex);
        }
    }

    private List<String> getMaintainerIDs(ArtifactCoordinates plugin) {
        String ga = plugin.groupId + ":" + plugin.artifactId;
        if (this.pluginToMaintainers.containsKey(ga)) {
            return this.pluginToMaintainers.get(ga);
        }
        List candidateGAs = this.pluginToMaintainers.keySet().stream().filter(s -> s.endsWith(":" + plugin.artifactId)).collect(Collectors.toList());
        switch (candidateGAs.size()) {
            case 1: {
                String key = (String)candidateGAs.get(0);
                LOGGER.log(Level.INFO, "Apparent mismatch of group IDs between permissions assignment: " + key + " and latest available release of plugin: " + String.valueOf(plugin));
                return this.pluginToMaintainers.get(key);
            }
            case 0: {
                LOGGER.log(Level.INFO, "No maintainer information found for plugin: " + String.valueOf(plugin));
                return new ArrayList<String>();
            }
        }
        LOGGER.log(Level.WARNING, "Multiple artifact IDs match, but none exactly. Will not provide maintainer information for plugin: " + String.valueOf(plugin));
        return new ArrayList<String>();
    }

    public List<Maintainer> getMaintainers(ArtifactCoordinates plugin) {
        return this.getMaintainerIDs(plugin).stream().map(key -> this.maintainerInfo.getOrDefault(key, new Maintainer((String)key, null))).collect(Collectors.toList());
    }

    private static class TypeReferenceForListOfJsonMaintainer
    extends TypeReference<List<JsonMaintainer>> {
        private TypeReferenceForListOfJsonMaintainer() {
        }
    }

    private static class TypeReferenceForHashMapFromStringToListOfString
    extends TypeReference<HashMap<String, List<String>>> {
        private TypeReferenceForHashMapFromStringToListOfString() {
        }
    }

    public static class Maintainer {
        private final String name;
        private final String developerId;

        public Maintainer(String id, String name) {
            this.developerId = id;
            this.name = name;
        }

        public String getDeveloperId() {
            return this.developerId;
        }

        public String getName() {
            return this.name;
        }
    }

    private static class JsonMaintainer {
        @JSONField
        public String displayName;
        @JSONField
        public String name;

        private JsonMaintainer() {
        }

        private Maintainer toMaintainer() {
            return new Maintainer(this.name, this.displayName);
        }
    }
}

