/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center;

import hudson.util.VersionNumber;
import io.jenkins.update_center.MavenRepository;
import io.jenkins.update_center.Plugin;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class LatestPluginVersions {
    private static LatestPluginVersions instance;
    private final Map<String, VersionNumber> latestVersions;

    private LatestPluginVersions(@Nonnull MavenRepository repository) throws IOException {
        this.latestVersions = repository.listJenkinsPlugins().stream().collect(Collectors.toMap(Plugin::getArtifactId, p -> p.getLatest().getVersion()));
    }

    private LatestPluginVersions(@Nonnull Map<String, VersionNumber> latestVersions) {
        this.latestVersions = latestVersions;
    }

    public static void initialize(@Nonnull MavenRepository repository) throws IOException {
        instance = new LatestPluginVersions(repository);
    }

    public static void initializeEmpty() {
        instance = new LatestPluginVersions(Collections.emptyMap());
    }

    @Nonnull
    public static LatestPluginVersions getInstance() {
        Objects.requireNonNull(instance, "instance");
        return instance;
    }

    public VersionNumber getLatestVersion(String pluginId) {
        return this.latestVersions.get(pluginId);
    }
}

