/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center;

import io.jenkins.update_center.IndexHtmlBuilder;
import io.jenkins.update_center.IndexTemplateProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LatestLinkBuilder
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(LatestLinkBuilder.class.getName());
    private final IndexHtmlBuilder index;
    private final PrintWriter htaccess;

    public LatestLinkBuilder(File dir, IndexTemplateProvider service) throws IOException {
        LOGGER.log(Level.FINE, String.format("Writing plugin symlinks and redirects to dir: %s", dir));
        this.index = service.newIndexHtmlBuilder(dir, "Permalinks to latest files");
        this.htaccess = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(dir, ".htaccess"), true), StandardCharsets.UTF_8));
        this.htaccess.println("# GENERATED. DO NOT MODIFY.");
        this.htaccess.println("RewriteEngine on");
    }

    @Override
    public void close() {
        this.index.close();
        this.htaccess.close();
    }

    public void add(String localPath, String target) throws IOException {
        this.htaccess.printf("RewriteRule ^%s$ %s [R=302,L]%n", localPath.replace(".", "\\."), target);
        this.index.add(localPath, localPath);
    }
}

