/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center;

import io.jenkins.update_center.IndexTemplateProvider;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class JenkinsIndexTemplateProvider
extends IndexTemplateProvider {
    private final String url;
    private static final Logger LOGGER = Logger.getLogger(JenkinsIndexTemplateProvider.class.getName());

    public JenkinsIndexTemplateProvider(String url) {
        this.url = url;
    }

    @Override
    protected String initTemplate() {
        String globalTemplate = "";
        try {
            Document doc = Jsoup.connect((String)this.url).get();
            doc.getElementsByAttribute("href").forEach(element -> this.setAbsoluteUrl((Element)element, "href"));
            doc.getElementsByAttribute("src").forEach(element -> this.setAbsoluteUrl((Element)element, "src"));
            globalTemplate = doc.toString();
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "Problem loading template", ioe);
        }
        return globalTemplate;
    }

    private void setAbsoluteUrl(Element element, String attributeName) {
        String attribute = element.attr(attributeName);
        if (attribute.startsWith("/")) {
            element.attr(attributeName, "https://www.jenkins.io" + attribute);
        }
    }
}

