/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.parser.Feature;
import io.jenkins.update_center.util.Environment;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class IssueTrackerSource {
    private static final Logger LOGGER = Logger.getLogger(IssueTrackerSource.class.getName());
    private static final String DATA_URL = Environment.getString("ISSUE_TRACKER_JSON_URL", "https://reports.jenkins.io/issues.index.json");
    private HashMap<String, List<IssueTracker>> pluginToIssueTrackers;
    private static IssueTrackerSource instance;

    public static synchronized IssueTrackerSource getInstance() {
        if (instance == null) {
            IssueTrackerSource its = new IssueTrackerSource();
            its.init();
            instance = its;
        }
        return instance;
    }

    private void init() {
        try {
            String jsonData = IOUtils.toString((URL)new URL(DATA_URL), (Charset)StandardCharsets.UTF_8);
            this.pluginToIssueTrackers = (HashMap)JSON.parseObject((String)jsonData, (Type)new TypeReferenceForHashMapFromStringToListOfIssueTracker().getType(), (Feature[])new Feature[0]);
        }
        catch (IOException | RuntimeException ex) {
            LOGGER.log(Level.WARNING, ex.getMessage());
            this.pluginToIssueTrackers = new HashMap();
        }
    }

    public List<IssueTracker> getIssueTrackers(String plugin) {
        return this.pluginToIssueTrackers.computeIfAbsent(plugin, p -> null);
    }

    private static class TypeReferenceForHashMapFromStringToListOfIssueTracker
    extends TypeReference<HashMap<String, List<IssueTracker>>> {
        private TypeReferenceForHashMapFromStringToListOfIssueTracker() {
        }
    }

    public static class IssueTracker {
        @JSONField
        public String type;
        @JSONField
        public String viewUrl;
        @JSONField
        public String reportUrl;
    }
}

