/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center;

import io.jenkins.update_center.HPI;
import io.jenkins.update_center.MavenArtifact;
import io.jenkins.update_center.MavenRepository;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.output.NullWriter;
import org.bouncycastle.util.encoders.Base64;

public class IndexHtmlBuilder
implements Closeable {
    private final PrintWriter out;
    private final String template;
    private final String title;
    private String subtitle;
    private final String description;
    private final StringBuilder content;
    private final String opengraphImage;

    public IndexHtmlBuilder(File dir, String title, String globalTemplate) throws IOException {
        this.out = IndexHtmlBuilder.openIndexHtml(dir);
        this.template = globalTemplate;
        this.title = title;
        this.content = new StringBuilder();
        this.subtitle = "";
        this.description = "Download previous versions of " + title;
        this.opengraphImage = "https://www.jenkins.io/images/logo-title-opengraph.png";
    }

    public IndexHtmlBuilder withSubtitle(String subtitle) {
        if (subtitle != null) {
            this.subtitle = subtitle;
        }
        return this;
    }

    private static PrintWriter openIndexHtml(File dir) throws IOException {
        if (dir == null) {
            return new PrintWriter((Writer)new NullWriter());
        }
        if (!dir.mkdirs() && !dir.isDirectory()) {
            throw new IllegalStateException("Failed to create " + String.valueOf(dir));
        }
        return new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(dir, "index.html")), StandardCharsets.UTF_8));
    }

    private String base64ToHex(String base64) {
        byte[] decodedBase64 = Base64.decode((byte[])base64.getBytes(StandardCharsets.US_ASCII));
        return Hex.encodeHexString((byte[])decodedBase64);
    }

    public void add(MavenArtifact a) throws IOException {
        MavenRepository.ArtifactMetadata artifactMetadata = a.getMetadata();
        if (artifactMetadata == null) {
            return;
        }
        if (a instanceof HPI) {
            this.add(a.getDownloadUrl().toExternalForm(), a.getTimestampAsDate(), a.version, artifactMetadata, ((HPI)a).getRequiredJenkinsVersion());
        } else {
            this.add(a.getDownloadUrl().toExternalForm(), a.getTimestampAsDate(), a.version, artifactMetadata, null);
        }
    }

    public void add(String url, String caption) {
        this.add(url, null, caption, null, null);
    }

    public void add(String url, Date releaseDate, String caption, MavenRepository.ArtifactMetadata metadata, String requiredJenkinsVersion) {
        Object releaseDateString = "";
        if (releaseDate != null) {
            releaseDateString = " Released: " + SimpleDateFormat.getDateInstance().format(releaseDate);
        }
        this.content.append("<li").append((String)(releaseDate == null ? "" : " id=\"" + caption + "\"")).append("><a class=\"version\" href='").append(url).append("'>").append(caption).append("</a><div class=\"metadata\">\n<div class=\"released\">").append((String)releaseDateString).append("</div>");
        if (metadata != null) {
            this.content.append("\n<div class=\"checksums\">SHA-1: <code>").append(this.base64ToHex(metadata.sha1)).append("</code></div>");
            if (metadata.sha256 != null) {
                this.content.append("\n<div class=\"checksums\">SHA-256: <code>").append(this.base64ToHex(metadata.sha256)).append("</code></div>");
            }
        }
        if (requiredJenkinsVersion != null) {
            this.content.append("\n<div class=\"core-dependency\">Requires Jenkins ").append(requiredJenkinsVersion).append("</div>");
        }
        this.content.append("</div></li>\n");
    }

    @Override
    public void close() {
        this.out.println(this.template.replace("{{ title }}", this.title).replace("{{ subtitle }}", this.subtitle).replace("{{ description }}", this.description).replace("{{ opengraphImage }}", this.opengraphImage).replace("{{ content }}", this.content.toString()));
        this.out.close();
    }
}

