/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class HealthScores {
    private static final Logger LOGGER = Logger.getLogger(HealthScores.class.getName());
    private static final String HEALTH_SCORES_URL = "https://reports.jenkins.io/plugin-health-scoring/scores.json";
    private static HealthScores instance;
    private final Map<String, Integer> healthScores;

    private HealthScores(Map<String, Integer> healthScores) {
        this.healthScores = healthScores;
    }

    public static synchronized HealthScores getInstance() {
        if (instance == null) {
            HealthScores.initialize();
        }
        return instance;
    }

    private static void initialize() {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(HEALTH_SCORES_URL)).GET().build();
        try (HttpClient client = HttpClient.newHttpClient();){
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            JsonResponse jsonResponse = (JsonResponse)JSON.parseObject((String)response.body(), JsonResponse.class);
            if (jsonResponse.plugins == null) {
                throw new IOException("Specified healthScore URL 'https://reports.jenkins.io/plugin-health-scoring/scores.json' does not contain a JSON object 'plugins'");
            }
            Map<String, Integer> healthScores = jsonResponse.plugins.keySet().stream().collect(Collectors.toMap(Function.identity(), pluginId -> jsonResponse.plugins.get((Object)pluginId).value));
            instance = new HealthScores(healthScores);
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.WARNING, e.getMessage());
            instance = new HealthScores(Map.of());
        }
    }

    public Integer getHealthScore(String pluginId) {
        return this.healthScores.get(pluginId);
    }

    private static class JsonResponse {
        public Map<String, PluginResponse> plugins;

        private JsonResponse() {
        }
    }

    private static class PluginResponse {
        public int value;

        private PluginResponse() {
        }
    }
}

