/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center;

import com.alibaba.fastjson.annotation.JSONField;
import hudson.util.VersionNumber;
import io.jenkins.update_center.ArtifactCoordinates;
import io.jenkins.update_center.BaseMavenRepository;
import io.jenkins.update_center.GitHubSource;
import io.jenkins.update_center.JenkinsWar;
import io.jenkins.update_center.Main;
import io.jenkins.update_center.MavenArtifact;
import io.jenkins.update_center.Plugin;
import io.jenkins.update_center.XmlCache;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.HtmlSanitizer;
import org.owasp.html.HtmlStreamEventProcessor;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.HtmlStreamEventReceiverWrapper;
import org.owasp.html.HtmlStreamRenderer;
import org.owasp.html.Sanitizers;
import org.xml.sax.SAXException;

public class HPI
extends MavenArtifact {
    private final Plugin plugin;
    private static final Properties URL_OVERRIDES = new Properties();
    private static final Properties LABEL_DEFINITIONS = new Properties();
    private static final Properties ALLOWED_GITHUB_LABELS = new Properties();
    private String description;
    private String name;
    private Document pom;
    private String pluginUrl;
    private String scmUrl;
    private boolean scmUrlCached;
    private List<String> labels;
    private String defaultBranch;
    public static final Function<HtmlStreamEventReceiver, HtmlSanitizer.Policy> HTML_POLICY;
    public static final HtmlStreamEventProcessor PRE_PROCESSOR;
    private static final SAXReader xmlReader;
    private static final Logger LOGGER;

    public HPI(BaseMavenRepository repository, ArtifactCoordinates artifact, Plugin plugin) {
        super(repository, artifact);
        this.plugin = plugin;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public URL getDownloadUrl() throws MalformedURLException {
        return new URL(StringUtils.removeEnd((String)DOWNLOADS_ROOT_URL, (String)"/") + "/plugins/" + this.artifact.artifactId + "/" + this.version + "/" + this.artifact.artifactId + ".hpi");
    }

    public static boolean isValidCoreDependency(String version) {
        return version.matches("[12][.](0|[1-9][0-9]*)([.][1-9])?");
    }

    public void validate() throws IOException {
        this.getRequiredJenkinsVersion();
    }

    public String getRequiredJenkinsVersion() throws IOException {
        String v = this.getManifestAttributes().getValue("Jenkins-Version");
        if (v != null) {
            if (!HPI.isValidCoreDependency(v)) {
                throw new IOException("Invalid Jenkins-Version in " + String.valueOf(this) + ": " + v);
            }
            return v;
        }
        v = this.getManifestAttributes().getValue("Hudson-Version");
        if (HPI.fixNull(v) != null) {
            if (!HPI.isValidCoreDependency(v)) {
                throw new IOException("Invalid Hudson-Version in " + String.valueOf(this) + ": " + v);
            }
            VersionNumber n = new VersionNumber(v);
            if (n.compareTo(JenkinsWar.HUDSON_CUT_OFF) <= 0) {
                return v;
            }
        }
        return "1.398";
    }

    private static String fixNull(String v) {
        if ("null".equals(v)) {
            return null;
        }
        return v;
    }

    public String getCompatibleSinceVersion() throws IOException {
        return this.getManifestAttributes().getValue("Compatible-Since-Version");
    }

    public List<Dependency> getDependencies() throws IOException {
        String deps = this.getManifestAttributes().getValue("Plugin-Dependencies");
        if (deps == null) {
            return Collections.emptyList();
        }
        ArrayList<Dependency> r = new ArrayList<Dependency>();
        for (String token : deps.split(",")) {
            r.add(new Dependency(token));
        }
        return r;
    }

    private String plainText2html(String plainText) {
        if (plainText == null || plainText.length() == 0) {
            return "";
        }
        return plainText.replace("&", "&amp;").replace("<", "&lt;");
    }

    public String getDescription() throws IOException {
        if (this.description == null) {
            Object description = this.plainText2html(this.readSingleValueFromXmlFile(this.resolvePOM(), "/project/description"));
            ArtifactCoordinates coordinates = new ArtifactCoordinates(this.artifact.groupId, this.artifact.artifactId, this.artifact.version, "jar");
            try (InputStream is = this.repository.getZipFileEntry(new MavenArtifact(this.repository, coordinates), "index.jelly");){
                StringBuilder b = new StringBuilder();
                HtmlStreamRenderer renderer = HtmlStreamRenderer.create((Appendable)b, Throwable::printStackTrace, html -> LOGGER.log(Level.INFO, "Bad HTML: '" + html + "' in " + this.artifact.getGav()));
                HtmlSanitizer.sanitize((String)IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8), (HtmlSanitizer.Policy)HTML_POLICY.apply((HtmlStreamEventReceiver)renderer), (HtmlStreamEventProcessor)PRE_PROCESSOR);
                description = b.toString().trim().replaceAll("\\s+", " ");
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, () -> "Failed to read description from index.jelly: " + e.getMessage());
            }
            if (this.isAlphaOrBeta()) {
                description = "<b>(This version is experimental and may change in backward-incompatible ways)</b><br><br>" + (String)description;
            }
            this.description = description;
        }
        return this.description;
    }

    public String getName() throws IOException {
        if (this.name == null) {
            String title = this.readSingleValueFromXmlFile(this.resolvePOM(), "/project/name");
            title = title == null || "".equals(title) ? this.artifact.artifactId : HPI.simplifyPluginName(title);
            this.name = title;
        }
        return this.name;
    }

    static String simplifyPluginName(String name) {
        name = org.apache.commons.lang3.StringUtils.removeStart((String)name, (String)"Jenkins ");
        name = org.apache.commons.lang3.StringUtils.removeStart((String)name, (String)"Hudson ");
        name = org.apache.commons.lang3.StringUtils.removeEndIgnoreCase((String)name, (String)" for Jenkins");
        name = org.apache.commons.lang3.StringUtils.removeEndIgnoreCase((String)name, (String)" Jenkins Plugin");
        name = org.apache.commons.lang3.StringUtils.removeEndIgnoreCase((String)name, (String)" Plugin");
        name = org.apache.commons.lang3.StringUtils.removeEndIgnoreCase((String)name, (String)" Plug-In");
        name = name.replaceAll("[- .!]+$", "");
        return name;
    }

    private String readSingleValueFromXmlFile(File file, String xpath) {
        try {
            XmlCache.CachedValue cached = XmlCache.readCache(file, xpath);
            if (cached == null) {
                Document doc = xmlReader.read(file);
                Node node = HPI.selectSingleNode(doc, xpath);
                String ret = node != null ? ((Element)node).getTextTrim() : null;
                XmlCache.writeCache(file, xpath, ret);
                return ret;
            }
            return cached.value;
        }
        catch (DocumentException e) {
            return null;
        }
    }

    private static Node selectSingleNode(Document pom, String path) {
        Node result = pom.selectSingleNode(path);
        if (result == null) {
            result = pom.selectSingleNode(path.replaceAll("/", "/m:"));
        }
        return result;
    }

    private Document getPom() throws IOException {
        if (this.pom == null) {
            this.pom = this.readPOM();
        }
        return this.pom;
    }

    private static SAXReader createXmlReader() {
        DocumentFactory factory = new DocumentFactory();
        factory.setXPathNamespaceURIs(Collections.singletonMap("m", "http://maven.apache.org/POM/4.0.0"));
        SAXReader reader = new SAXReader(factory);
        try {
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (SAXException ex) {
            LOGGER.log(Level.WARNING, "Failed to set safety features on SAXReader", ex);
        }
        return reader;
    }

    private Document readPOM() throws IOException {
        try {
            return xmlReader.read(this.resolvePOM());
        }
        catch (DocumentException e) {
            LOGGER.log(Level.INFO, "Failed to parse POM for " + this.artifact.getGav(), e);
            return null;
        }
    }

    public String getPluginUrl() throws IOException {
        if (this.pluginUrl == null) {
            String url = URL_OVERRIDES.getProperty(this.artifact.artifactId);
            if (url == null) {
                url = this.getManifestAttributes().getValue("Url");
            }
            if (url == null) {
                url = this.readSingleValueFromXmlFile(this.resolvePOM(), "/project/url");
            }
            if (url == null || url.startsWith("https://plugins.jenkins.io")) {
                url = HPI.requireTopLevelUrl(this.getScmUrl());
            }
            String originalUrl = url;
            if (url != null) {
                url = url.replace("wiki.hudson-ci.org/display/HUDSON/", "wiki.jenkins-ci.org/display/JENKINS/");
                url = url.replace("http://wiki.jenkins-ci.org", "https://wiki.jenkins.io");
            }
            if (url != null && !url.equals(originalUrl)) {
                LOGGER.fine("Rewrote URL for plugin " + this.artifact.getGav() + " from " + originalUrl + " to " + url);
            }
            this.pluginUrl = url;
        }
        return this.pluginUrl;
    }

    static String requireTopLevelUrl(String scmUrl) {
        if (scmUrl == null) {
            return null;
        }
        String[] parts = scmUrl.split("/");
        if (parts.length > 5) {
            return null;
        }
        return scmUrl;
    }

    private String filterKnownObsoleteUrls(String scm) {
        if (scm == null) {
            return null;
        }
        if (scm.contains("fisheye.jenkins-ci.org")) {
            return null;
        }
        if (scm.contains("svn.jenkins-ci.org")) {
            return null;
        }
        if (scm.contains("svn.java.net")) {
            return null;
        }
        if (scm.contains("svn.dev.java.net")) {
            return null;
        }
        if (scm.contains("hudson.dev.java.net")) {
            return null;
        }
        if (scm.contains("jenkinsci/plugin-pom")) {
            return null;
        }
        return scm;
    }

    private String _getScmUrl() {
        try {
            String scm = this.readSingleValueFromXmlFile(this.resolvePOM(), "/project/scm/url");
            if (scm == null) {
                LOGGER.log(Level.FINER, "No SCM URL found in POM for " + this.artifact.getGav());
                Element parent = (Element)HPI.selectSingleNode(this.getPom(), "/project/parent");
                if (parent != null) {
                    try {
                        File parentPomFile = this.repository.resolve(new ArtifactCoordinates(parent.element("groupId").getTextTrim(), parent.element("artifactId").getTextTrim(), parent.element("version").getTextTrim(), "pom"));
                        scm = this.readSingleValueFromXmlFile(parentPomFile, "/project/scm/url");
                        if (scm == null) {
                            LOGGER.log(Level.FINER, "No SCM URL found in parent POM for " + this.artifact.getGav());
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, "Failed to read parent POM for " + this.artifact.getGav(), ex);
                    }
                }
            }
            if (scm == null) {
                return null;
            }
            if (this.filterKnownObsoleteUrls(scm) == null) {
                LOGGER.log(Level.FINE, "Filtered obsolete URL " + scm + " in SCM URL for " + this.artifact.getGav());
                return null;
            }
            return scm;
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Failed to read POM for " + this.artifact.getGav(), ex);
            return null;
        }
    }

    private String getScmUrlFromDeveloperConnection() {
        try {
            String scm = this.readSingleValueFromXmlFile(this.resolvePOM(), "/project/scm/developerConnection");
            if (scm == null) {
                LOGGER.log(Level.FINE, "No SCM developerConnection found in POM for " + this.artifact.getGav());
                Element parent = (Element)HPI.selectSingleNode(this.getPom(), "/project/parent");
                if (parent != null) {
                    try {
                        File parentPomFile = this.repository.resolve(new ArtifactCoordinates(parent.element("groupId").getTextTrim(), parent.element("artifactId").getTextTrim(), parent.element("version").getTextTrim(), "pom"));
                        scm = this.readSingleValueFromXmlFile(parentPomFile, "/project/scm/developerConnection");
                        if (scm == null) {
                            LOGGER.log(Level.FINE, "No SCM developerConnection found in parent POM for " + this.artifact.getGav());
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, "Failed to read parent POM for " + this.artifact.getGav(), ex);
                    }
                }
            }
            if (scm == null) {
                return null;
            }
            if (this.filterKnownObsoleteUrls(scm) == null) {
                LOGGER.log(Level.FINE, "Filtered obsolete URL " + scm + " in SCM developerConnection for " + this.artifact.getGav());
                return null;
            }
            return scm;
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Failed to read POM for " + this.artifact.getGav(), ex);
            return null;
        }
    }

    private String interpolateProjectName(String str) {
        if (str == null) {
            return null;
        }
        str = str.replace("${project.artifactId}", this.artifact.artifactId);
        str = str.replace("${artifactId}", this.artifact.artifactId);
        return str;
    }

    private String requireHttpsGitHubJenkinsciUrl(String url) {
        if (url == null) {
            return null;
        }
        if (url.contains("github.com:jenkinsci/") || url.contains("github.com/jenkinsci/")) {
            String githubUrl = url.substring(url.indexOf("github.com"));
            if ((githubUrl = githubUrl.replace(":", "/")).endsWith(".git")) {
                githubUrl = githubUrl.substring(0, githubUrl.lastIndexOf(".git"));
            }
            if (githubUrl.endsWith("/")) {
                githubUrl = githubUrl.substring(0, githubUrl.lastIndexOf("/"));
            }
            return "https://" + githubUrl;
        }
        return null;
    }

    private String requireGitHubRepoExistence(String url) {
        GitHubSource gh = GitHubSource.getInstance();
        String shortenedUrl = org.apache.commons.lang3.StringUtils.removeEndIgnoreCase((String)url, (String)"-plugin");
        return gh.isRepoExisting(url) ? url : (gh.isRepoExisting(shortenedUrl) ? shortenedUrl : null);
    }

    public String getScmUrl() throws IOException {
        if (!this.scmUrlCached) {
            this.scmUrlCached = true;
            if (this.resolvePOM().exists()) {
                Object scm = this._getScmUrl();
                if (scm == null) {
                    scm = this.getScmUrlFromDeveloperConnection();
                }
                if (scm == null) {
                    LOGGER.log(Level.FINE, "Failed to determine SCM URL from POM or parent POM of " + this.artifact.getGav());
                }
                scm = this.interpolateProjectName((String)scm);
                String originalScm = scm;
                scm = this.requireHttpsGitHubJenkinsciUrl((String)scm);
                if (originalScm != null && scm == null) {
                    LOGGER.log(Level.CONFIG, "Rejecting URL outside GitHub.com/jenkinsci for " + this.artifact.getGav() + ": " + originalScm);
                }
                if (scm == null) {
                    scm = "https://github.com/jenkinsci/" + this.artifact.artifactId + "-plugin";
                    LOGGER.log(Level.FINE, "Falling back to default pattern repo for " + this.artifact.getGav() + ": " + (String)scm);
                    Object checkedScm = scm;
                    scm = this.requireGitHubRepoExistence((String)scm);
                    if (scm == null) {
                        LOGGER.log(Level.FINE, "Repository does not actually exist: " + (String)checkedScm);
                    }
                }
                this.scmUrl = scm;
            }
        }
        return this.scmUrl;
    }

    private OrgAndRepo getOrgAndRepo(String scmUrl) {
        if (scmUrl == null || !scmUrl.startsWith("https://github.com/")) {
            return null;
        }
        String[] parts = scmUrl.replaceFirst("https://github.com/", "").split("[/]");
        if (parts.length >= 2) {
            return new OrgAndRepo(parts[0], parts[1]);
        }
        return null;
    }

    public List<String> getLabels() throws IOException {
        if (this.labels == null) {
            String scm = this.getScmUrl();
            ArrayList<String> gitHubLabels = new ArrayList<String>();
            OrgAndRepo orgAndRepo = this.getOrgAndRepo(scm);
            if (orgAndRepo != null) {
                ArrayList<String> unsanitizedLabels = new ArrayList<String>(Arrays.asList(GitHubSource.getInstance().getRepositoryTopics(orgAndRepo.org, orgAndRepo.repo).toArray(new String[0])));
                for (String label : unsanitizedLabels) {
                    if (label.startsWith("jenkins-")) {
                        label = label.replaceFirst("jenkins-", "");
                    }
                    if (!ALLOWED_GITHUB_LABELS.containsKey(label)) continue;
                    gitHubLabels.add(label);
                }
                if (!gitHubLabels.isEmpty()) {
                    LOGGER.log(Level.FINE, () -> this.artifact.artifactId + " got the following labels contributed from GitHub: " + org.apache.commons.lang3.StringUtils.join((Iterable)gitHubLabels, (String)", "));
                }
            }
            TreeSet<String> labels = new TreeSet<String>(Arrays.asList(this.getLabelsFromFile()));
            labels.addAll(gitHubLabels);
            this.labels = new ArrayList<String>(labels);
        }
        return this.labels;
    }

    public String getDefaultBranch() throws IOException {
        String scm;
        OrgAndRepo orgAndRepo;
        if (this.defaultBranch == null && (orgAndRepo = this.getOrgAndRepo(scm = this.getScmUrl())) != null) {
            this.defaultBranch = GitHubSource.getInstance().getDefaultBranch(orgAndRepo.org, orgAndRepo.repo);
        }
        return this.defaultBranch;
    }

    private String[] getLabelsFromFile() {
        Object ret = LABEL_DEFINITIONS.get(this.artifact.artifactId);
        if (ret == null) {
            return new String[0];
        }
        String labels = ret.toString();
        if (labels.trim().length() == 0) {
            return new String[0];
        }
        return labels.split("\\s+");
    }

    static {
        try (InputStream overridesStream = Files.newInputStream(new File(Main.resourcesDir, "wiki-overrides.properties").toPath(), new OpenOption[0]);
             InputStream labelStream = Files.newInputStream(new File(Main.resourcesDir, "label-definitions.properties").toPath(), new OpenOption[0]);
             InputStream allowedTopicsStream = Files.newInputStream(new File(Main.resourcesDir, "allowed-github-topics.properties").toPath(), new OpenOption[0]);){
            URL_OVERRIDES.load(overridesStream);
            LABEL_DEFINITIONS.load(labelStream);
            ALLOWED_GITHUB_LABELS.load(allowedTopicsStream);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        HTML_POLICY = Sanitizers.FORMATTING.and(Sanitizers.LINKS).and(new HtmlPolicyBuilder().allowElements(new String[]{"a"}).requireRelsOnLinks(new String[]{"noopener", "noreferrer"}).allowAttributes(new String[]{"target"}).matching(false, new String[]{"_blank"}).onElements(new String[]{"a"}).toFactory());
        PRE_PROCESSOR = receiver -> new HtmlStreamEventReceiverWrapper(receiver){

            public void openTag(String elementName, List<String> attrs) {
                if ("a".equals(elementName)) {
                    attrs.add("target");
                    attrs.add("_blank");
                }
                super.openTag(elementName, attrs);
            }
        };
        xmlReader = HPI.createXmlReader();
        LOGGER = Logger.getLogger(HPI.class.getName());
    }

    public static class Dependency {
        @JSONField
        public final String name;
        @JSONField
        public final String version;
        @JSONField
        public final boolean optional;
        private static final String OPTIONAL_RESOLUTION = ";resolution:=optional";

        public Dependency(String token) {
            this.optional = token.endsWith(OPTIONAL_RESOLUTION);
            if (this.optional) {
                token = token.substring(0, token.length() - OPTIONAL_RESOLUTION.length());
            }
            String[] pieces = token.split(":");
            this.name = pieces[0];
            this.version = pieces[1];
        }
    }

    private static class OrgAndRepo {
        private final String org;
        private final String repo;

        private OrgAndRepo(String org, String repo) {
            this.org = org;
            this.repo = repo;
        }
    }
}

