/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.util.VersionNumber;
import io.jenkins.update_center.HPI;
import io.jenkins.update_center.IndexHtmlBuilder;
import io.jenkins.update_center.IndexTemplateProvider;
import io.jenkins.update_center.JenkinsIndexTemplateProvider;
import io.jenkins.update_center.JenkinsWar;
import io.jenkins.update_center.LatestLinkBuilder;
import io.jenkins.update_center.MavenArtifact;
import io.jenkins.update_center.MavenRepository;
import io.jenkins.update_center.Plugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import org.apache.commons.io.IOUtils;
import org.kohsuke.args4j.Option;

public class DirectoryTreeBuilder {
    private static final Logger LOGGER = Logger.getLogger(DirectoryTreeBuilder.class.getName());
    @Option(name="--latest-links-directory", usage="Directory to contain links to latest releases and .htaccess redirects")
    public File latest;
    @Option(name="--downloads-directory", usage="Build mirrors.jenkins-ci.org layout (containing .war and .hpi files)")
    public File download = null;
    @Option(name="--download-links-directory", usage="Build downloads web index files")
    public File wwwDownload = null;
    @Option(name="--index-template-url", usage="Url of a template for index files")
    public String indexTemplate = null;

    public void build(MavenRepository repo) throws IOException {
        IndexTemplateProvider indexTemplateProvider = this.indexTemplate == null ? new IndexTemplateProvider() : new JenkinsIndexTemplateProvider(this.indexTemplate);
        try (LatestLinkBuilder latestLinks = this.prepareLatestLinkBuilder(indexTemplateProvider);){
            for (Plugin plugin : repo.listJenkinsPlugins()) {
                if (latestLinks != null) {
                    latestLinks.add(plugin.getArtifactId() + ".hpi", plugin.getLatest().getDownloadUrl().toExternalForm());
                }
                TreeMap<VersionNumber, HPI> artifacts = plugin.getArtifacts();
                if (this.download != null) {
                    for (HPI v : artifacts.values()) {
                        this.stage(v, new File(this.download, "plugins/" + plugin.getArtifactId() + "/" + v.version + "/" + plugin.getArtifactId() + ".hpi"));
                    }
                    if (!artifacts.isEmpty()) {
                        this.createLatestSymlink(plugin);
                    }
                }
                if (this.wwwDownload == null) continue;
                String permalink = String.format("/latest/%s.hpi", plugin.getArtifactId());
                this.buildIndex(new File(this.wwwDownload, "plugins/" + plugin.getArtifactId()), plugin.getLatest().getName(), plugin.getArtifactId(), artifacts.values(), permalink, indexTemplateProvider);
            }
            TreeMap<VersionNumber, JenkinsWar> jenkinsWars = repo.getJenkinsWarsByVersionNumber();
            if (!jenkinsWars.isEmpty()) {
                if (latestLinks != null) {
                    latestLinks.add("jenkins.war", jenkinsWars.firstEntry().getValue().getDownloadUrl().toExternalForm());
                }
                if (this.download != null) {
                    for (JenkinsWar w : jenkinsWars.values()) {
                        this.stage(w, new File(this.download, "war/" + w.version + "/" + w.getFileName()));
                    }
                }
                if (this.wwwDownload != null) {
                    this.buildIndex(new File(this.wwwDownload, "war/"), "jenkins.war", null, jenkinsWars.values(), "/latest/jenkins.war", indexTemplateProvider);
                }
            }
        }
    }

    @CheckForNull
    private LatestLinkBuilder prepareLatestLinkBuilder(IndexTemplateProvider service) throws IOException {
        if (this.latest == null) {
            return null;
        }
        if (!this.latest.mkdirs() && !this.latest.isDirectory()) {
            throw new IOException("Failed to created 'latest' directory at " + String.valueOf(this.latest));
        }
        return new LatestLinkBuilder(this.latest, service);
    }

    private void createLatestSymlink(Plugin hpi) throws IOException {
        File dir = new File(this.download, "plugins/" + hpi.getArtifactId());
        File latest = new File(dir, "latest");
        if (latest.exists() && !latest.delete()) {
            throw new IOException("Failed to delete " + String.valueOf(latest));
        }
        if (System.getProperty("os.name").toLowerCase(Locale.US).contains("windows")) {
            return;
        }
        Path newLink = Paths.get("latest", new String[0]);
        Path existingFile = Paths.get(hpi.getLatest().version, new String[0]);
        try {
            Files.deleteIfExists(newLink);
            Files.createSymbolicLink(newLink, existingFile, new FileAttribute[0]);
        }
        catch (IOException | UnsupportedOperationException ex) {
            LOGGER.log(Level.WARNING, "Failed to link", ex);
        }
    }

    @SuppressFBWarnings(value={"COMMAND_INJECTION"}, justification="No injection risk from absolute path args to ln -s")
    protected void stage(MavenArtifact a, File dst) throws IOException {
        File src = a.resolve();
        if (dst.exists() && dst.lastModified() == src.lastModified() && dst.length() == src.length()) {
            LOGGER.log(Level.FINEST, () -> "Destination file " + String.valueOf(dst) + " for artifact " + String.valueOf(a) + " already exists");
            return;
        }
        File parentFile = dst.getParentFile();
        if (!parentFile.mkdirs() && !parentFile.isDirectory()) {
            throw new IOException("Failed to create " + String.valueOf(parentFile));
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        if (System.getProperty("os.name").toLowerCase(Locale.US).contains("windows")) {
            return;
        }
        pb.command("ln", "-f", src.getAbsolutePath(), dst.getAbsolutePath());
        Process p = pb.start();
        try {
            if (p.waitFor() != 0) {
                throw new IOException("'ln -f " + src.getAbsolutePath() + " " + dst.getAbsolutePath() + "' failed with code " + p.exitValue() + "\nError: " + IOUtils.toString((InputStream)p.getErrorStream()) + "\nOutput: " + IOUtils.toString((InputStream)p.getInputStream()));
            }
            LOGGER.log(Level.INFO, "Created new download file " + String.valueOf(dst) + " from " + String.valueOf(src));
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.WARNING, "Interrupted creating " + String.valueOf(dst) + " from " + String.valueOf(src), ex);
        }
    }

    private void buildIndex(File dir, String title, String subtitle, Collection<? extends MavenArtifact> versions, String permalink, IndexTemplateProvider service) throws IOException {
        ArrayList<? extends MavenArtifact> list = new ArrayList<MavenArtifact>(versions);
        list.sort(Comparator.comparing(MavenArtifact::getVersion).reversed());
        try (IndexHtmlBuilder index = service.newIndexHtmlBuilder(dir, title).withSubtitle(subtitle);){
            index.add(permalink, "permalink to the latest");
            for (MavenArtifact mavenArtifact : list) {
                try {
                    index.add(mavenArtifact);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, "Failed to add " + String.valueOf(mavenArtifact), ex);
                }
            }
        }
    }
}

