/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center;

import io.jenkins.update_center.BaseMavenRepository;
import io.jenkins.update_center.Main;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import java.util.stream.Stream;

public class Deprecations {
    private static final Properties DEPRECATIONS = new Properties();

    private Deprecations() {
    }

    public static String getCustomDeprecationUri(String pluginName) {
        return DEPRECATIONS.getProperty(pluginName);
    }

    public static Stream<String> getDeprecatedPlugins() {
        return Stream.concat(DEPRECATIONS.keySet().stream(), BaseMavenRepository.getIgnoresWithDeprecationUrl()).map(Object::toString);
    }

    static {
        try (InputStream stream = Files.newInputStream(new File(Main.resourcesDir, "deprecations.properties").toPath(), new OpenOption[0]);){
            DEPRECATIONS.load(stream);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }
}

