/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center;

import hudson.util.VersionNumber;
import io.jenkins.update_center.ArtifactCoordinates;
import io.jenkins.update_center.HPI;
import io.jenkins.update_center.JenkinsWar;
import io.jenkins.update_center.Main;
import io.jenkins.update_center.MavenRepository;
import io.jenkins.update_center.Plugin;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseMavenRepository
implements MavenRepository {
    private static final Properties IGNORE = new Properties();

    public static Stream<Object> getIgnoresWithDeprecationUrl() {
        return IGNORE.keySet().stream().filter(s -> BaseMavenRepository.isUrl(IGNORE.getProperty(s.toString())));
    }

    private static boolean isUrl(String property) {
        return !StringUtils.isEmpty((CharSequence)property) && !property.trim().startsWith("#");
    }

    public static String getIgnoreNoticeUrl(String artifactId) {
        return IGNORE.getProperty(artifactId);
    }

    @Override
    public Collection<Plugin> listJenkinsPlugins() throws IOException {
        TreeMap<String, Plugin> plugins = new TreeMap<String, Plugin>(String.CASE_INSENSITIVE_ORDER);
        HashSet<String> excluded = new HashSet<String>();
        Collection<ArtifactCoordinates> results = this.listAllPlugins();
        for (ArtifactCoordinates artifactCoordinates : results) {
            if (artifactCoordinates.version.contains("SNAPSHOT") || artifactCoordinates.version.contains("JENKINS")) continue;
            if (IGNORE.containsKey(artifactCoordinates.artifactId)) {
                if (!excluded.add(artifactCoordinates.artifactId)) continue;
                LOGGER.log(Level.CONFIG, "Ignoring " + artifactCoordinates.artifactId + " because this artifact is suspended");
                continue;
            }
            if (IGNORE.containsKey(artifactCoordinates.artifactId + "@" + artifactCoordinates.version)) {
                LOGGER.log(Level.CONFIG, "Ignoring " + artifactCoordinates.artifactId + ", version " + artifactCoordinates.version + " because this version is suspended");
                continue;
            }
            if (!artifactCoordinates.isVersionValid()) {
                LOGGER.log(Level.CONFIG, "Ignoring " + artifactCoordinates.artifactId + ", version " + artifactCoordinates.version + " because this version is not valid");
                continue;
            }
            Plugin plugin = (Plugin)plugins.get(artifactCoordinates.artifactId);
            if (plugin == null) {
                plugin = new Plugin(artifactCoordinates.artifactId);
                plugins.put(artifactCoordinates.artifactId, plugin);
            }
            HPI hpi = new HPI(this, artifactCoordinates, plugin);
            plugin.addArtifact(hpi);
        }
        TreeMap<String, Plugin> ret = new TreeMap<String, Plugin>(String.CASE_INSENSITIVE_ORDER);
        ret.putAll(plugins);
        return ret.values();
    }

    @Override
    public TreeMap<VersionNumber, JenkinsWar> getJenkinsWarsByVersionNumber() throws IOException {
        TreeMap<VersionNumber, JenkinsWar> r = new TreeMap<VersionNumber, JenkinsWar>(VersionNumber.DESCENDING);
        this.addWarsInGroupIdToMap(r, "org.jenkins-ci.main", null);
        this.addWarsInGroupIdToMap(r, "org.jvnet.hudson.main", JenkinsWar.HUDSON_CUT_OFF);
        return r;
    }

    protected abstract Set<ArtifactCoordinates> listAllJenkinsWars(String var1) throws IOException;

    @Override
    public void addWarsInGroupIdToMap(Map<VersionNumber, JenkinsWar> releases, String groupId, VersionNumber cap) throws IOException {
        Set<ArtifactCoordinates> results = this.listAllJenkinsWars(groupId);
        for (ArtifactCoordinates artifactCoordinates : results) {
            if (artifactCoordinates.version.contains("SNAPSHOT") || artifactCoordinates.version.contains("JENKINS") || !artifactCoordinates.artifactId.equals("jenkins-war") && !artifactCoordinates.artifactId.equals("hudson-war")) continue;
            if (IGNORE.containsKey(artifactCoordinates.artifactId + "@" + artifactCoordinates.version)) {
                LOGGER.log(Level.CONFIG, "Ignoring " + artifactCoordinates.artifactId + ", version " + artifactCoordinates.version + " because this version is suspended");
                continue;
            }
            if (cap != null && new VersionNumber(artifactCoordinates.version).compareTo(cap) > 0) continue;
            VersionNumber version = new VersionNumber(artifactCoordinates.version);
            releases.put(version, new JenkinsWar(this, artifactCoordinates));
        }
    }

    static {
        try (InputStream stream = Files.newInputStream(new File(Main.resourcesDir, "artifact-ignores.properties").toPath(), new OpenOption[0]);){
            IGNORE.load(stream);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }
}

