/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center;

import com.alibaba.fastjson.JSON;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.update_center.ArtifactCoordinates;
import io.jenkins.update_center.BaseMavenRepository;
import io.jenkins.update_center.MavenArtifact;
import io.jenkins.update_center.MavenRepository;
import io.jenkins.update_center.util.Environment;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.tools.ant.filters.StringInputStream;

public class ArtifactoryRepositoryImpl
extends BaseMavenRepository {
    private static final Logger LOGGER = Logger.getLogger(ArtifactoryRepositoryImpl.class.getName());
    private static final String ARTIFACTORY_URL = Environment.getString("ARTIFACTORY_URL", "https://repo.jenkins-ci.org/");
    private static final String ARTIFACTORY_API_URL = Environment.getString("ARTIFACTORY_API_URL", "https://repo.jenkins-ci.org/api/");
    private static final String ARTIFACTORY_REPOSITORY = Environment.getString("ARTIFACTORY_REPOSITORY", "releases");
    private static final String ARTIFACTORY_AQL_URL = ARTIFACTORY_API_URL + "search/aql";
    private static final String ARTIFACTORY_MANIFEST_URL = ARTIFACTORY_URL + "%s/%s!/META-INF/MANIFEST.MF";
    private static final String ARTIFACTORY_ZIP_ENTRY_URL = ARTIFACTORY_URL + "%s/%s!%s";
    private static final String ARTIFACTORY_FILE_URL = ARTIFACTORY_URL + "%s/%s";
    private static final String AQL_QUERY = "items.find({\"repo\":{\"$eq\":\"" + ARTIFACTORY_REPOSITORY + "\"},\"$or\":[{\"name\":{\"$match\":\"*.hpi\"}},{\"name\":{\"$match\":\"*.jpi\"}},{\"name\":{\"$match\":\"*.war\"}},{\"name\":{\"$match\":\"*.pom\"}}]}).include(\"repo\", \"path\", \"name\", \"modified\", \"created\", \"sha256\", \"actual_sha1\", \"size\")";
    private final String username;
    private final String password;
    private File cacheDirectory = new File(Environment.getString("ARTIFACTORY_CACHEDIR", "caches/artifactory"));
    private boolean initialized = false;
    private Map<String, JsonFile> files = new HashMap<String, JsonFile>();
    private Set<ArtifactCoordinates> plugins;
    private Set<ArtifactCoordinates> wars;
    private Set<ArtifactCoordinates> poms;
    private Map<String, String> cache = new HashMap<String, String>();
    private static final int CACHE_ENTRY_MAX_LENGTH = 65536;
    private static final File LOCAL_REPO = new File(new File(System.getProperty("user.home")), ".m2/repository");

    public ArtifactoryRepositoryImpl(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    protected Set<ArtifactCoordinates> listAllJenkinsWars(String groupId) throws IOException {
        this.ensureInitialized();
        return this.wars;
    }

    private static boolean containsIllegalChars(String test) {
        return !test.chars().allMatch(c -> c >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122 || c == 43 || c == 45 || c == 46 || c == 47 || c == 95);
    }

    private static ArtifactCoordinates toGav(JsonFile f) {
        String fileName = f.name;
        String path = f.path;
        if (ArtifactoryRepositoryImpl.containsIllegalChars(fileName) || ArtifactoryRepositoryImpl.containsIllegalChars(path)) {
            LOGGER.log(Level.INFO, "Characters outside allowed set: " + f.path + " / " + f.name);
            return null;
        }
        int gaToV = path.lastIndexOf(47);
        if (gaToV <= 0) {
            LOGGER.log(Level.INFO, "Unexpected path/name: " + f.path + " / " + f.name);
            return null;
        }
        String version = path.substring(gaToV + 1);
        String ga = path.substring(0, gaToV);
        int gToA = ga.lastIndexOf(47);
        if (gToA <= 0) {
            LOGGER.log(Level.INFO, "Unexpected path/name: " + f.path + " / " + f.name);
            return null;
        }
        String artifactId = ga.substring(gToA + 1);
        String groupId = ga.substring(0, gToA).replace('/', '.');
        int baseNameToExtension = fileName.lastIndexOf(46);
        String extension = fileName.substring(baseNameToExtension + 1);
        String baseName = fileName.substring(0, baseNameToExtension);
        String expectedFileName = artifactId + "-" + version + "." + extension;
        if (!fileName.equals(expectedFileName)) {
            LOGGER.log(Level.INFO, "File name: " + fileName + " does not match expected file name: " + expectedFileName);
            return null;
        }
        int classifierBeginIndex = artifactId.length() + 1 + version.length() + 1;
        if (classifierBeginIndex < baseName.length()) {
            LOGGER.log(Level.INFO, "Unexpectedly have classifier for path: " + path + " name: " + fileName);
            return null;
        }
        return new ArtifactCoordinates(groupId, artifactId, version, extension);
    }

    @Override
    public Collection<ArtifactCoordinates> listAllPlugins() throws IOException {
        this.ensureInitialized();
        return this.plugins;
    }

    private void initialize() throws IOException {
        if (this.initialized) {
            throw new IllegalStateException("re-initialized");
        }
        LOGGER.log(Level.INFO, "Initializing " + this.getClass().getName());
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(ARTIFACTORY_AQL_URL)).POST(HttpRequest.BodyPublishers.ofString(AQL_QUERY)).header("Accept", "application/json").header("Authorization", "Basic " + Base64.encodeBase64String((byte[])(this.username + ":" + this.password).getBytes(StandardCharsets.UTF_8))).build();
        try (HttpClient client = HttpClient.newHttpClient();){
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            ((JsonResponse)JSON.parseObject((String)response.body(), JsonResponse.class)).results.forEach(result -> this.files.put("/" + result.path + "/" + result.name, (JsonFile)result));
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        this.poms = this.files.values().stream().filter(it -> it.name.endsWith(".pom")).map(ArtifactoryRepositoryImpl::toGav).filter(Objects::nonNull).collect(Collectors.toSet());
        this.plugins = this.files.values().stream().filter(it -> it.name.endsWith(".hpi") || it.name.endsWith(".jpi")).map(ArtifactoryRepositoryImpl::toGav).filter(Objects::nonNull).collect(Collectors.toSet());
        ArtifactoryRepositoryImpl.removeIf(this.plugins, it -> !this.poms.contains(new ArtifactCoordinates(it.groupId, it.artifactId, it.version, "pom")));
        this.wars = this.files.values().stream().filter(it -> it.name.endsWith(".war")).map(ArtifactoryRepositoryImpl::toGav).collect(Collectors.toSet());
        ArtifactoryRepositoryImpl.removeIf(this.wars, it -> !this.poms.contains(new ArtifactCoordinates(it.groupId, it.artifactId, it.version, "pom")));
        LOGGER.log(Level.INFO, "Initialized " + this.getClass().getName());
    }

    private static <E> void removeIf(Collection<E> collection, Predicate<? super E> filter) {
        Iterator<E> each = collection.iterator();
        while (each.hasNext()) {
            E current = each.next();
            if (!filter.test(current)) continue;
            each.remove();
            LOGGER.log(Level.INFO, "Removing artifact file without corresponding pom file: " + String.valueOf(current));
        }
    }

    private String hexToBase64(String hex) throws IOException {
        try {
            byte[] decodedHex = Hex.decodeHex((String)hex);
            return Base64.encodeBase64String((byte[])decodedHex);
        }
        catch (DecoderException e) {
            throw new IOException("failed to convert hex to base64", e);
        }
    }

    @Override
    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"}, justification="Catching NPE is safer than trying to guard all cases")
    public MavenRepository.ArtifactMetadata getMetadata(MavenArtifact artifact) throws IOException {
        this.ensureInitialized();
        MavenRepository.ArtifactMetadata ret = new MavenRepository.ArtifactMetadata();
        JsonFile jsonFile = this.files.get("/" + this.getUri(artifact.artifact));
        try {
            ret.sha1 = this.hexToBase64(jsonFile.actual_sha1);
        }
        catch (NullPointerException e) {
            LOGGER.log(Level.WARNING, "No artifact: " + artifact.toString());
            return null;
        }
        String hexSha256 = jsonFile.sha256;
        if (hexSha256 == null) {
            LOGGER.log(Level.WARNING, "No SHA-256: " + artifact.toString());
            return null;
        }
        ret.sha256 = this.hexToBase64(hexSha256);
        ret.timestamp = jsonFile.modified.getTime();
        ret.size = jsonFile.size;
        return ret;
    }

    private void ensureInitialized() throws IOException {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
    }

    private String getUri(ArtifactCoordinates a) {
        String basename = a.artifactId + "-" + a.version;
        String filename = basename + "." + a.packaging;
        return a.groupId.replace(".", "/") + "/" + a.artifactId + "/" + a.version + "/" + filename;
    }

    @Override
    public Manifest getManifest(MavenArtifact artifact) throws IOException {
        try (InputStream is = this.getFileContent(String.format(ARTIFACTORY_MANIFEST_URL, ARTIFACTORY_REPOSITORY, this.getUri(artifact.artifact)));){
            Manifest manifest = new Manifest(is);
            return manifest;
        }
    }

    private InputStream getFileContent(String url) throws IOException {
        if (this.cache.containsKey(url)) {
            String entry = this.cache.get(url);
            if (entry == null) {
                throw new IOException("Failed to retrieve content of " + url + " (cached)");
            }
            return new StringInputStream(entry);
        }
        File cacheFile = this.getFile(url);
        return new FileInputStream(cacheFile);
    }

    private File getFile(String url) throws IOException {
        File cacheFile;
        block37: {
            String path = URI.create(url).getPath();
            String sha256 = DigestUtils.sha256Hex((String)path);
            String sha256prefix = sha256.substring(0, 2);
            File cachePrefixDir = new File(this.cacheDirectory, sha256prefix);
            if (!cachePrefixDir.exists() && !cachePrefixDir.mkdirs()) {
                LOGGER.log(Level.WARNING, "Failed to create cache prefix directory " + String.valueOf(cachePrefixDir));
            }
            if (!(cacheFile = new File(cachePrefixDir, sha256)).exists()) {
                LOGGER.log(Level.INFO, "Downloading : " + url + " (not found in cache) to " + cacheFile.getName());
                File parentFile = cacheFile.getParentFile();
                if (!parentFile.mkdirs() && !parentFile.isDirectory()) {
                    throw new IllegalStateException("Failed to create non-existing directory " + String.valueOf(parentFile));
                }
                try (HttpClient client = HttpClient.newHttpClient();){
                    HttpRequest request = HttpRequest.newBuilder().GET().uri(URI.create(url)).header("Authorization", "Basic " + Base64.encodeBase64String((byte[])(this.username + ":" + this.password).getBytes(StandardCharsets.UTF_8))).build();
                    HttpResponse<InputStream> response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
                    try (InputStream is = response.body();){
                        if (response.statusCode() == 200 || response.statusCode() == 204) {
                            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                 FileOutputStream fos = new FileOutputStream(cacheFile);
                                 TeeOutputStream tos = new TeeOutputStream((OutputStream)fos, (OutputStream)baos);){
                                IOUtils.copy((InputStream)is, (OutputStream)tos);
                                if (baos.size() <= 65536) {
                                    String value = baos.toString(StandardCharsets.UTF_8);
                                    LOGGER.log(Level.FINE, () -> "Caching in memory: " + url + " with content: " + value);
                                    this.cache.put(url, value);
                                }
                                break block37;
                            }
                        }
                        LOGGER.log(Level.INFO, "Received HTTP error response: " + response.statusCode() + " for URL: " + url);
                        if (!cacheFile.mkdir()) {
                            LOGGER.log(Level.WARNING, "Failed to create cache 'not found' directory" + String.valueOf(cacheFile));
                        }
                        break block37;
                    }
                }
                catch (InterruptedException | RuntimeException e) {
                    throw new IOException(e);
                }
            }
            if (cacheFile.isDirectory()) {
                this.cache.put(url, null);
                throw new IOException("Failed to retrieve content of " + url + " (cached)");
            }
            if (cacheFile.length() <= 65536L) {
                this.cache.put(url, FileUtils.readFileToString((File)cacheFile, (Charset)StandardCharsets.UTF_8));
            }
        }
        return cacheFile;
    }

    @Override
    public InputStream getZipFileEntry(MavenArtifact artifact, String path) throws IOException {
        return this.getFileContent(String.format(ARTIFACTORY_ZIP_ENTRY_URL, ARTIFACTORY_REPOSITORY, this.getUri(artifact.artifact), StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0])));
    }

    @Override
    public File resolve(ArtifactCoordinates artifact) throws IOException {
        String uri = this.getUri(artifact);
        File localFile = new File(LOCAL_REPO, uri);
        if (localFile.exists()) {
            return localFile;
        }
        return this.getFile(String.format(ARTIFACTORY_FILE_URL, ARTIFACTORY_REPOSITORY, uri));
    }

    private static class JsonFile {
        public String path;
        public String name;
        public String actual_sha1;
        public String sha256;
        public Date modified;
        public long size;

        private JsonFile() {
        }
    }

    private static class JsonResponse {
        public List<JsonFile> results;

        private JsonResponse() {
        }
    }
}

