/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.update_center;

import java.util.Objects;

public class ArtifactCoordinates {
    public final String groupId;
    public final String artifactId;
    public final String version;
    public final String packaging;

    public ArtifactCoordinates(String groupId, String artifactId, String version, String packaging) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.packaging = packaging;
    }

    public String getGav() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version + ":" + this.packaging;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactCoordinates that = (ArtifactCoordinates)o;
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.version, that.version) && Objects.equals(this.packaging, that.packaging);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version, this.packaging);
    }

    public boolean isVersionValid() {
        return this.version.matches("[0-9]+([-.].*)?");
    }
}

