/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Optional;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.ZipFileSet;
import org.jenkinsci.maven.plugins.hpi.MavenArtifact;
import org.jenkinsci.maven.plugins.hpi.RunMojo;

@Mojo(name="custom-war", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class WarMojo
extends RunMojo {
    @Parameter
    protected String jenkinsWarId;
    @Parameter
    protected File outputFile;
    @Parameter(property="addThisPluginToCustomWar", defaultValue="false")
    private boolean addThisPluginToCustomWar = false;
    @Component
    protected MavenProjectHelper projectHelper;

    @Override
    public void execute() throws MojoExecutionException {
        if (this.outputFile == null) {
            this.outputFile = new File(this.getProject().getBasedir(), "target/" + this.getProject().getArtifactId() + ".war");
        }
        File war = this.getJenkinsWarArtifact().getFile();
        Zip rezip = new Zip();
        rezip.setDestFile(this.outputFile);
        rezip.setProject(new Project());
        ZipFileSet z = new ZipFileSet();
        z.setSrc(war);
        rezip.addZipfileset(z);
        this.getProject().setArtifacts(this.resolveDependencies(this.dependencyResolution));
        LinkedHashSet<MavenArtifact> projectArtifacts = new LinkedHashSet<MavenArtifact>(this.getProjectArtifacts());
        if (this.getProject().getPackaging().equals("hpi") && this.addThisPluginToCustomWar) {
            Optional.ofNullable(this.getProject()).map(MavenProject::getArtifact).map(a -> {
                projectArtifacts.add(this.wrap((Artifact)a));
                this.getLog().debug((CharSequence)("This plugin " + String.valueOf(a) + "to be added to custom war"));
                return projectArtifacts;
            });
        }
        for (MavenArtifact a2 : projectArtifacts) {
            if (!a2.isPlugin(this.getLog())) continue;
            Artifact hpi = this.artifactFactory.createArtifact(a2.getGroupId(), a2.getArtifactId(), a2.getVersion(), null, "hpi");
            if ((hpi = MavenArtifact.resolveArtifact(hpi, this.project, this.session, this.repositorySystem)).getFile().isDirectory()) {
                throw new UnsupportedOperationException(String.valueOf(hpi.getFile()) + " is a directory and not packaged yet. this isn't supported");
            }
            z = new ZipFileSet();
            z.setFile(hpi.getFile());
            z.setFullpath("WEB-INF/plugins/" + hpi.getArtifactId() + ".hpi");
            rezip.addZipfileset(z);
        }
        rezip.execute();
        this.getLog().info((CharSequence)("Generated " + String.valueOf(this.outputFile)));
        this.projectHelper.attachArtifact(this.getProject(), "war", this.outputFile);
    }
}

