/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.util.VersionNumber;
import io.jenkins.lib.support_log_formatter.SupportLogFormatter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.jar.JarFile;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.util.filter.ScopeDependencyFilter;
import org.eclipse.jetty.ee9.maven.plugin.JettyRunWarMojo;
import org.eclipse.jetty.ee9.maven.plugin.MavenWebAppContext;
import org.eclipse.jetty.ee9.servlet.ServletContextHandler;
import org.eclipse.jetty.ee9.webapp.WebAppClassLoader;
import org.eclipse.jetty.ee9.webapp.WebAppContext;
import org.eclipse.jetty.ee9.websocket.server.config.JettyWebSocketServletContainerInitializer;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.maven.MavenServerConnector;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Credential;
import org.eclipse.jetty.util.security.Password;
import org.jenkinsci.maven.plugins.hpi.Artifacts;
import org.jenkinsci.maven.plugins.hpi.JettyAndServletApiOnlyClassLoader;
import org.jenkinsci.maven.plugins.hpi.MavenArtifact;
import org.jenkinsci.maven.plugins.hpi.PluginWorkspaceMap;
import org.twdata.maven.mojoexecutor.MojoExecutor;
import sun.misc.Unsafe;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.TEST)
@Execute(phase=LifecyclePhase.COMPILE)
public class RunMojo
extends JettyRunWarMojo {
    private static final Map<String, String> REQUIRED_PACKAGES_TO_TEST_CLASSES = Map.of("java.lang", "String$CaseInsensitiveComparator", "java.util", "UUID$Holder");
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Parameter(property="webAppFile")
    private File webAppFile;
    @Parameter(property="hudsonHome", defaultValue="${HUDSON_HOME}")
    private File hudsonHome;
    @Parameter(property="jenkinsHome", defaultValue="${JENKINS_HOME}")
    private File jenkinsHome;
    @Parameter(defaultValue="test")
    protected String dependencyResolution;
    @Parameter(defaultValue="${basedir}/src/main/webapp")
    protected File warSourceDirectory;
    @Component
    protected RepositorySystem repositorySystem;
    @Component
    protected ArtifactFactory artifactFactory;
    @Component
    private ProjectDependenciesResolver dependenciesResolver;
    @Component
    private BuildPluginManager pluginManager;
    @Parameter(property="port", defaultValue="8080")
    protected int defaultPort;
    @Parameter(property="host", defaultValue="localhost")
    protected String defaultHost;
    @Parameter(property="wildcardDNS")
    protected String wildcardDNS;
    @Deprecated
    @Parameter(property="jetty.consoleForceReload", defaultValue="true")
    protected boolean consoleForceReload;
    @Component
    protected ProjectBuilder projectBuilder;
    @Parameter
    protected String jenkinsCoreId;
    @Parameter
    protected String jenkinsWarId;
    @Parameter
    protected String maskClasses;
    @Parameter
    protected boolean pluginFirstClassLoader = false;
    @Parameter
    private Map<String, String> loggers;
    private Collection<Logger> loggerReferences;
    @Deprecated
    @Parameter
    private String minimumJavaVersion;
    @Deprecated
    @Parameter(readonly=true, required=true, defaultValue="/${project.artifactId}")
    protected String contextPath;
    @Component
    protected PluginWorkspaceMap pluginWorkspaceMap;
    private static final String VERSION_PATH = "META-INF/maven/org.jenkins-ci.main/jenkins-war/pom.properties";
    private static final String VERSION_PROP = "version";

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.openInternalPackagesIfRequired();
        this.getProject().setArtifacts(this.resolveDependencies(this.dependencyResolution));
        File basedir = this.getProject().getBasedir();
        if ((this.webApp == null || this.webApp.getContextPath() == null) && this.contextPath != null) {
            this.getLog().warn((CharSequence)"Please use `webApp/contextPath` configuration parameter in place of the deprecated `contextPath` parameter");
            if (this.webApp == null) {
                try {
                    this.webApp = new MavenWebAppContext(){

                        protected ClassLoader configureClassLoader(ClassLoader loader) {
                            return RunMojo.this.getWebAppClassLoader((WebAppContext)this);
                        }
                    };
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Failed to initialize webApp configuration", e);
                }
            }
            this.webApp.setContextPath(this.contextPath);
        }
        if (this.jenkinsHome == null) {
            String h;
            if (this.hudsonHome != null) {
                this.getLog().warn((CharSequence)"Please use the `jenkinsHome` configuration parameter in place of the deprecated `hudsonHome` parameter");
                this.jenkinsHome = this.hudsonHome;
            }
            if ((h = System.getenv("JENKINS_HOME")) == null) {
                h = System.getenv("HUDSON_HOME");
            }
            this.jenkinsHome = h != null && !h.isEmpty() && !h.equals("null") ? new File(h) : new File(basedir, "work");
        }
        this.setSystemPropertyIfEmpty("stapler.trace", "true");
        this.setSystemPropertyIfEmpty("org.eclipse.jetty.server.Request.maxFormContentSize", "-1");
        this.setSystemPropertyIfEmpty("hudson.hpi.run", "true");
        this.setSystemPropertyIfEmpty("jenkins.moduleRoot", basedir.getAbsolutePath());
        Artifacts jenkinsArtifacts = Artifacts.of(this.getProject()).groupIdIs("org.jenkins-ci.main", "org.jvnet.hudson.main").artifactIdIsNot("remoting");
        if (this.webAppFile == null) {
            Artifact jenkinsWarArtifact = MavenArtifact.resolveArtifact(this.getJenkinsWarArtifact(), this.project, this.session, this.repositorySystem);
            this.webAppFile = jenkinsWarArtifact.getFile();
            if (this.webAppFile == null || !this.webAppFile.isFile()) {
                throw new MojoExecutionException("Could not find " + String.valueOf(this.webAppFile) + " from " + String.valueOf(jenkinsWarArtifact));
            }
        }
        for (Artifact a : jenkinsArtifacts) {
            Artifact ba = (Artifact)jenkinsArtifacts.get(0);
            if (a.getVersion().equals(ba.getVersion())) continue;
            throw new MojoExecutionException("Version of " + a.getId() + " is inconsistent with " + ba.getId());
        }
        this.setSystemPropertyIfEmpty("JENKINS_HOME", this.jenkinsHome.getAbsolutePath());
        File pluginsDir = new File(this.jenkinsHome, "plugins");
        try {
            Files.createDirectories(pluginsDir.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create directories for '" + String.valueOf(pluginsDir) + "'", (Exception)e);
        }
        this.setSystemPropertyIfEmpty("stapler.jelly.noCache", "true");
        List res = this.getProject().getBuild().getResources();
        if (!res.isEmpty()) {
            org.apache.maven.model.Resource r = (org.apache.maven.model.Resource)res.get(0);
            this.setSystemPropertyIfEmpty("stapler.resourcePath", r.getDirectory());
        }
        this.generateHpl();
        try {
            for (MavenArtifact mavenArtifact : this.getProjectArtifacts()) {
                if (!mavenArtifact.isPlugin(this.getLog())) continue;
                Artifact hpi = this.artifactFactory.createArtifact(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getVersion(), null, "hpi");
                if (this.hasSameGavAsProject(hpi = MavenArtifact.resolveArtifact(hpi, this.project, this.session, this.repositorySystem))) continue;
                if (hpi.getFile().isDirectory()) {
                    throw new UnsupportedOperationException(String.valueOf(hpi.getFile()) + " is a directory and not packaged yet. this isn't supported");
                }
                File upstreamHpl = this.pluginWorkspaceMap.read(hpi.getId());
                String actualArtifactId = mavenArtifact.getActualArtifactId();
                if (actualArtifactId == null) {
                    throw new MojoExecutionException("Failed to load actual artifactId from " + String.valueOf(mavenArtifact) + " ~ " + String.valueOf(mavenArtifact.getFile()));
                }
                if (upstreamHpl != null) {
                    this.copyHpl(upstreamHpl, pluginsDir, actualArtifactId);
                    continue;
                }
                this.copyPlugin(hpi.getFile(), pluginsDir, actualArtifactId);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy dependency plugin", (Exception)e);
        }
        if (System.getProperty("java.util.logging.config.file") == null) {
            System.setProperty("org.apache.juli.formatter", SupportLogFormatter.class.getName());
        }
        if (this.loggers != null) {
            for (Handler h : LogManager.getLogManager().getLogger("").getHandlers()) {
                if (!(h instanceof ConsoleHandler)) continue;
                h.setLevel(Level.ALL);
            }
            this.loggerReferences = new LinkedList<Logger>();
            for (Map.Entry entry : this.loggers.entrySet()) {
                Logger l = Logger.getLogger((String)entry.getKey());
                this.loggerReferences.add(l);
                l.setLevel(Level.parse((String)entry.getValue()));
            }
        }
        super.execute();
    }

    private void openInternalPackagesIfRequired() {
        Runtime.Version runtimeVersion = Runtime.version();
        if (runtimeVersion.feature() < 16) {
            return;
        }
        try {
            List<String> unavailableRequiredPackages = RunMojo.unavailableRequiredPackages();
            if (!unavailableRequiredPackages.isEmpty()) {
                RunMojo.openPackages(unavailableRequiredPackages);
                List<String> failedToOpen = RunMojo.unavailableRequiredPackages();
                if (!failedToOpen.isEmpty()) {
                    Object warning = "Some required internal classes are unavailable. Please consider adding the following JVM arguments: ";
                    warning = (String)warning + failedToOpen.stream().map(pkg -> "--add-opens java.base/" + pkg + "=ALL-UNNAMED").collect(Collectors.joining(" "));
                    this.getLog().warn((CharSequence)warning);
                }
            }
        }
        catch (Throwable t) {
            this.getLog().error((CharSequence)"Failed to check for available JDK packages", t);
        }
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="workaround JDK11")
    private static List<String> unavailableRequiredPackages() {
        ArrayList<String> packages = new ArrayList<String>();
        for (Map.Entry<String, String> e : REQUIRED_PACKAGES_TO_TEST_CLASSES.entrySet()) {
            String key = e.getKey();
            String value = e.getValue();
            try {
                Class<?> clazz = Class.forName(key + "." + value);
                if (clazz.isEnum()) {
                    clazz.getMethod("values", new Class[0]).invoke(null, new Object[0]);
                    continue;
                }
                Constructor<?> c = clazz.getDeclaredConstructor(new Class[0]);
                c.setAccessible(true);
                c.newInstance(new Object[0]);
            }
            catch (InaccessibleObjectException ex) {
                packages.add(key);
            }
            catch (Exception exception) {}
        }
        return packages;
    }

    private static void openPackages(Collection<String> packagesToOpen) throws Throwable {
        Collection<?> modules = RunMojo.allModules();
        if (modules == null) {
            return;
        }
        Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
        unsafeField.setAccessible(true);
        Unsafe unsafe = (Unsafe)unsafeField.get(null);
        Field implLookupField = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
        MethodHandles.Lookup lookup = (MethodHandles.Lookup)unsafe.getObject(unsafe.staticFieldBase(implLookupField), unsafe.staticFieldOffset(implLookupField));
        MethodHandle modifiers = lookup.findSetter(Method.class, "modifiers", Integer.TYPE);
        Method exportMethod = Class.forName("java.lang.Module").getDeclaredMethod("implAddOpens", String.class);
        modifiers.invokeExact(exportMethod, 1);
        for (Object module : modules) {
            Collection packages = (Collection)module.getClass().getMethod("getPackages", new Class[0]).invoke(module, new Object[0]);
            for (String name : packages) {
                if (!packagesToOpen.contains(name)) continue;
                exportMethod.invoke(module, name);
            }
        }
    }

    @Nullable
    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="workaround JDK11")
    private static Collection<?> allModules() {
        try {
            Object boot = Class.forName("java.lang.ModuleLayer").getMethod("boot", new Class[0]).invoke(null, new Object[0]);
            if (boot == null) {
                return null;
            }
            Object modules = boot.getClass().getMethod("modules", new Class[0]).invoke(boot, new Object[0]);
            return (Collection)modules;
        }
        catch (Exception ignore) {
            return null;
        }
    }

    private boolean hasSameGavAsProject(Artifact a) {
        return this.getProject().getGroupId().equals(a.getGroupId()) && this.getProject().getArtifactId().equals(a.getArtifactId()) && this.getProject().getVersion().equals(a.getVersion());
    }

    private void setSystemPropertyIfEmpty(String name, String value) {
        if (System.getProperty(name) == null) {
            System.setProperty(name, value);
        }
    }

    private void copyPlugin(File src, File pluginsDir, String shortName) throws IOException {
        File dst = new File(pluginsDir, shortName + ".jpi");
        File hpi = new File(pluginsDir, shortName + ".hpi");
        if (Files.isRegularFile(hpi.toPath(), new LinkOption[0])) {
            this.getLog().warn((CharSequence)("Moving historical " + String.valueOf(hpi) + " to *.jpi"));
            Files.move(hpi.toPath(), dst.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        VersionNumber dstV = this.versionOfPlugin(dst);
        if (this.versionOfPlugin(src).compareTo(dstV) < 0) {
            this.getLog().info((CharSequence)("will not overwrite " + String.valueOf(dst) + " with " + String.valueOf(src) + " because " + String.valueOf(dstV) + " is newer"));
            return;
        }
        this.getLog().info((CharSequence)("Copying dependency Jenkins plugin " + String.valueOf(src)));
        FileUtils.copyFile((File)src, (File)dst);
        Files.writeString(pluginsDir.toPath().resolve(shortName + ".jpi.pinned"), (CharSequence)"pinned", StandardCharsets.US_ASCII, new OpenOption[0]);
        Files.deleteIfExists(new File(pluginsDir, shortName + ".jpl").toPath());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private VersionNumber versionOfPlugin(File p) throws IOException {
        if (!p.isFile()) {
            return new VersionNumber("0.0");
        }
        try (JarFile j = new JarFile(p);){
            String v = j.getManifest().getMainAttributes().getValue("Plugin-Version");
            if (v == null) {
                throw new IOException("no Plugin-Version in " + String.valueOf(p));
            }
            try {
                VersionNumber versionNumber = new VersionNumber(v);
                return versionNumber;
            }
            catch (IllegalArgumentException x) {
                throw new IOException("malformed Plugin-Version in " + String.valueOf(p) + ": " + String.valueOf(x), x);
            }
        }
        catch (IOException x) {
            throw new IOException("not a valid JarFile: " + String.valueOf(p), x);
        }
    }

    private void copyHpl(File src, File pluginsDir, String shortName) throws IOException {
        File dst = new File(pluginsDir, shortName + ".jpl");
        this.getLog().info((CharSequence)("Copying snapshot dependency Jenkins plugin " + String.valueOf(src)));
        FileUtils.copyFile((File)src, (File)dst);
        Files.writeString(pluginsDir.toPath().resolve(shortName + ".jpi.pinned"), (CharSequence)"pinned", StandardCharsets.US_ASCII, new OpenOption[0]);
    }

    private void generateHpl() throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.jenkins-ci.tools"), (String)MojoExecutor.artifactId((String)"maven-hpi-plugin")), (String)MojoExecutor.goal((String)"hpl"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"jenkinsHome"), (String)this.jenkinsHome.toString()), MojoExecutor.element((String)MojoExecutor.name((String)"pluginName"), (String)this.project.getName()), MojoExecutor.element((String)MojoExecutor.name((String)"warSourceDirectory"), (String)this.warSourceDirectory.toString()), MojoExecutor.element((String)MojoExecutor.name((String)"jenkinsCoreId"), (String)this.jenkinsCoreId), MojoExecutor.element((String)MojoExecutor.name((String)"pluginFirstClassLoader"), (String)Boolean.toString(this.pluginFirstClassLoader)), MojoExecutor.element((String)MojoExecutor.name((String)"maskClasses"), (String)this.maskClasses)}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }

    public void configureWebApp() throws Exception {
        File extractedWebAppDir;
        if (this.webApp.getTempDirectory() == null) {
            Path target = Paths.get(this.project.getBuild().getDirectory(), new String[0]);
            Path tmp = target.resolve("jetty");
            if (!Files.isDirectory(tmp, new LinkOption[0])) {
                Files.createDirectories(tmp, new FileAttribute[0]);
            }
            this.webApp.setTempDirectory(tmp.toFile());
        }
        if (this.isExtractedWebAppDirStale(extractedWebAppDir = new File(this.webApp.getTempDirectory(), "webapp"), this.webAppFile)) {
            FileUtils.deleteDirectory((File)extractedWebAppDir);
        }
        this.getWebAppConfig().setWar(this.webAppFile.getCanonicalPath());
        super.configureWebApp();
        for (Artifact a : this.project.getArtifacts()) {
            File coreBasedir;
            if (!a.getGroupId().equals("org.jenkins-ci.main") || !a.getArtifactId().equals("jenkins-core") || (coreBasedir = this.pluginWorkspaceMap.read(a.getId())) == null) continue;
            String extraCP = String.valueOf(new File(coreBasedir, "src/main/resources").toURI()) + "," + String.valueOf(new File(coreBasedir, "target/classes").toURI());
            this.getLog().info((CharSequence)("Will load directly from " + extraCP));
            this.getWebAppConfig().setExtraClasspath(extraCP);
        }
        JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)this.getWebAppConfig(), null);
        HashLoginService hashLoginService = new HashLoginService("default");
        UserStore userStore = new UserStore();
        hashLoginService.setUserStore(userStore);
        userStore.addUser("alice", (Credential)new Password("alice"), new String[]{"user", "female"});
        userStore.addUser("bob", (Credential)new Password("bob"), new String[]{"user", "male"});
        userStore.addUser("charlie", (Credential)new Password("charlie"), new String[]{"user", "male"});
        this.getWebAppConfig().getSecurityHandler().setLoginService((LoginService)hashLoginService);
        this.finishConfigurationBeforeStart();
    }

    private boolean isExtractedWebAppDirStale(File extractedWebAppDir, File webApp) throws IOException {
        String originalVersion;
        String extractedVersion;
        if (!extractedWebAppDir.isDirectory()) {
            this.getLog().info((CharSequence)(String.valueOf(extractedWebAppDir) + " does not yet exist, will receive " + String.valueOf(webApp)));
            return false;
        }
        if (extractedWebAppDir.lastModified() < webApp.lastModified()) {
            this.getLog().info((CharSequence)(String.valueOf(extractedWebAppDir) + " is older than " + String.valueOf(webApp) + ", will recreate"));
            return true;
        }
        File extractedPath = new File(extractedWebAppDir, VERSION_PATH);
        if (!extractedPath.isFile()) {
            this.getLog().warn((CharSequence)("no such file " + String.valueOf(extractedPath)));
            return false;
        }
        try (FileInputStream is = new FileInputStream(extractedPath);){
            extractedVersion = this.loadVersion(is);
        }
        if (extractedVersion == null) {
            this.getLog().warn((CharSequence)("no version in " + String.valueOf(extractedPath)));
            return false;
        }
        try (ZipFile zip = new ZipFile(webApp);){
            ZipEntry entry = zip.getEntry(VERSION_PATH);
            if (entry == null) {
                this.getLog().warn((CharSequence)("no META-INF/maven/org.jenkins-ci.main/jenkins-war/pom.properties in " + String.valueOf(webApp)));
                boolean bl = false;
                return bl;
            }
            try (InputStream is = zip.getInputStream(entry);){
                originalVersion = this.loadVersion(is);
            }
        }
        if (originalVersion == null) {
            this.getLog().warn((CharSequence)("no version in jar:" + String.valueOf(webApp.toURI()) + "!/META-INF/maven/org.jenkins-ci.main/jenkins-war/pom.properties"));
            return false;
        }
        if (!extractedVersion.equals(originalVersion)) {
            this.getLog().info((CharSequence)("Version " + extractedVersion + " in " + String.valueOf(extractedWebAppDir) + " does not match " + originalVersion + " in " + String.valueOf(webApp) + ", will recreate"));
            return true;
        }
        this.getLog().info((CharSequence)(String.valueOf(extractedWebAppDir) + " already up to date with respect to " + String.valueOf(webApp)));
        return false;
    }

    private String loadVersion(InputStream is) throws IOException {
        Properties props = new Properties();
        props.load(is);
        return props.getProperty(VERSION_PROP);
    }

    public void startScanner() throws Exception {
        HttpConfiguration hc = ((HttpConnectionFactory)this.httpConnector.getConnectionFactory(HttpConnectionFactory.class)).getHttpConfiguration();
        hc.setHttpCompliance(HttpCompliance.RFC7230);
        hc.setUriCompliance(UriCompliance.LEGACY);
        hc.setResponseHeaderSize(12288);
        super.startScanner();
    }

    protected boolean isPackagingSupported() {
        if (!this.supportedPackagings.contains("hpi")) {
            ArrayList<String> newSupportedPackagings = new ArrayList<String>(this.supportedPackagings);
            newSupportedPackagings.add("hpi");
            this.supportedPackagings = List.copyOf(newSupportedPackagings);
        }
        return super.isPackagingSupported();
    }

    private void finishConfigurationBeforeStart() {
        WebAppContext wac = this.getWebAppConfig();
        wac.getSessionHandler().getSessionCookieConfig().setName("JSESSIONID." + UUID.randomUUID().toString().replace("-", "").substring(0, 8));
    }

    private ClassLoader getWebAppClassLoader(WebAppContext wac) {
        try {
            WebAppClassLoader wacl = new WebAppClassLoader(new JettyAndServletApiOnlyClassLoader(ClassLoader.getPlatformClassLoader(), ((Object)((Object)this)).getClass().getClassLoader()), (WebAppClassLoader.Context)wac){
                private final Pattern exclusionPattern;
                {
                    if (RunMojo.this.getProject().getPackaging().equals("jenkins-module")) {
                        for (org.apache.maven.model.Resource r : RunMojo.this.getProject().getResources()) {
                            super.addURL(new File(r.getDirectory()).toURI().toURL());
                        }
                        super.addURL(new File(RunMojo.this.getProject().getBuild().getOutputDirectory()).toURI().toURL());
                        for (Artifact a : Artifacts.of(RunMojo.this.getProject()).scopeIsNot("provided", "test").typeIsNot("pom")) {
                            super.addURL(a.getFile().toURI().toURL());
                        }
                        this.exclusionPattern = Pattern.compile("[/\\\\]\\Q" + RunMojo.this.getProject().getArtifactId() + "\\E-[0-9]([^/\\\\]+)\\.jar$");
                    } else {
                        this.exclusionPattern = Pattern.compile("this should never match");
                    }
                }

                public void addClassPath(String classPath) throws IOException {
                    if (this.exclusionPattern != null && this.exclusionPattern.matcher(classPath).find()) {
                        return;
                    }
                    super.addClassPath(classPath);
                }

                public void addJars(Resource lib) {
                    super.addJars(lib);
                }
            };
            return wacl;
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public void startJetty() throws MojoExecutionException, MojoFailureException {
        if (this.httpConnector == null && (this.defaultPort != 0 || this.defaultHost != null && !this.defaultHost.isEmpty())) {
            Object browserHost;
            this.httpConnector = new MavenServerConnector();
            if (this.defaultPort != 0) {
                this.httpConnector.setPort(this.defaultPort);
            }
            if (this.defaultHost != null && !this.defaultHost.isEmpty()) {
                this.httpConnector.setHost(this.defaultHost);
            }
            if (this.wildcardDNS != null && "localhost".equals(this.defaultHost)) {
                browserHost = this.getProject().getArtifactId() + ".127.0.0.1." + this.wildcardDNS;
            } else {
                this.getLog().info((CharSequence)"Try setting -DwildcardDNS=nip.io in a profile");
                browserHost = this.httpConnector.getHost();
            }
            this.getLog().info((CharSequence)("===========> Browse to: http://" + (String)browserHost + ":" + (this.defaultPort != 0 ? this.defaultPort : 8080) + this.webApp.getContextPath() + "/"));
        }
        super.startJetty();
    }

    protected Set<Artifact> resolveDependencies(String scope) throws MojoExecutionException {
        try {
            DefaultDependencyResolutionRequest request = new DefaultDependencyResolutionRequest(this.getProject(), this.session.getRepositorySession());
            request.setResolutionFilter(RunMojo.getDependencyFilter(scope));
            DependencyResolutionResult result = this.dependenciesResolver.resolve((DependencyResolutionRequest)request);
            LinkedHashSet<Artifact> artifacts = new LinkedHashSet<Artifact>();
            if (result.getDependencyGraph() != null && !result.getDependencyGraph().getChildren().isEmpty()) {
                RepositoryUtils.toArtifacts(artifacts, (Collection)result.getDependencyGraph().getChildren(), List.of(this.getProject().getArtifact().getId()), (DependencyFilter)request.getResolutionFilter());
            }
            return artifacts;
        }
        catch (DependencyResolutionException e) {
            throw new MojoExecutionException("Unable to copy dependency plugin", (Exception)((Object)e));
        }
    }

    private static DependencyFilter getDependencyFilter(String scope) {
        switch (scope) {
            case "compile": {
                return new ScopeDependencyFilter(new String[]{"runtime", "test"});
            }
            case "runtime": {
                return new ScopeDependencyFilter(new String[]{"system", "provided", "test"});
            }
            case "test": {
                return null;
            }
        }
        throw new IllegalArgumentException("unexpected scope: " + scope);
    }

    public Set<MavenArtifact> getProjectArtifacts() {
        HashSet<MavenArtifact> r = new HashSet<MavenArtifact>();
        for (Artifact a : this.getProject().getArtifacts()) {
            r.add(this.wrap(a));
        }
        return r;
    }

    protected MavenArtifact wrap(Artifact a) {
        return new MavenArtifact(a, this.repositorySystem, this.artifactFactory, this.projectBuilder, this.session, this.project);
    }

    protected Artifact getJenkinsWarArtifact() throws MojoExecutionException {
        for (Artifact a : this.resolveDependencies("test")) {
            boolean match;
            if (this.jenkinsWarId != null) {
                match = (a.getGroupId() + ":" + a.getArtifactId()).equals(this.jenkinsWarId);
            } else {
                boolean bl = match = !(!a.getArtifactId().equals("jenkins-war") && !a.getArtifactId().equals("hudson-war") || !a.getType().equals("executable-war") && !a.getType().equals("war"));
            }
            if (!match) continue;
            return a;
        }
        if (this.jenkinsWarId != null) {
            this.getLog().error((CharSequence)("Unable to locate jenkins.war in '" + this.jenkinsWarId + "'"));
        } else {
            this.getLog().error((CharSequence)"Unable to locate jenkins.war. Add the following dependency in your POM:\n\n<dependency>\n  <groupId>org.jenkins-ci.main</groupId>\n  <artifactId>jenkins-war</artifactId>\n  <type>war</type>\n  <version>1.396<!-- replace this with the version you want--></version>\n  <scope>test</scope>\n</dependency>");
        }
        throw new MojoExecutionException("Unable to find jenkins.war");
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public WebAppContext getWebAppConfig() {
        return this.webApp;
    }
}

