/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.todeclarative.converter.scm;

import hudson.scm.SubversionSCM;
import io.jenkins.plugins.todeclarative.converter.api.ConverterRequest;
import io.jenkins.plugins.todeclarative.converter.api.ConverterResult;
import io.jenkins.plugins.todeclarative.converter.api.ModelASTUtils;
import io.jenkins.plugins.todeclarative.converter.api.SingleTypedConverter;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTArgumentList;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTBranch;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTPipelineDef;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTSingleArgument;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStage;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStep;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTValue;
import org.jenkinsci.plugins.variant.OptionalExtension;

@OptionalExtension(requirePlugins={"subversion"})
public class SubversionScmConverter
extends SingleTypedConverter<SubversionSCM> {
    public boolean convert(ConverterRequest request, ConverterResult result, Object target) {
        SubversionSCM subversionSCM = (SubversionSCM)target;
        SubversionSCM.ModuleLocation[] locations = subversionSCM.getLocations();
        if (locations == null || locations.length < 1) {
            return true;
        }
        ModelASTStage stage = new ModelASTStage((Object)this);
        ArrayList<ModelASTStep> steps = new ArrayList<ModelASTStep>();
        stage.setName("Checkout Scm");
        ModelASTStep checkout = new ModelASTStep(null);
        checkout.setName("checkout");
        ModelASTSingleArgument singleArgument = new ModelASTSingleArgument(null);
        checkout.setArgs((ModelASTArgumentList)singleArgument);
        StringBuilder gstring = new StringBuilder("[$class: 'SubversionSCM'");
        if (StringUtils.isNotEmpty((CharSequence)subversionSCM.getExcludedCommitMessages())) {
            gstring.append(",excludedCommitMessages:'").append(subversionSCM.getExcludedCommitMessages()).append("'");
        }
        if (StringUtils.isNotEmpty((CharSequence)subversionSCM.getExcludedRegions())) {
            gstring.append(",excludedRegions:'").append(subversionSCM.getExcludedRegions()).append("'");
        }
        if (StringUtils.isNotEmpty((CharSequence)subversionSCM.getExcludedRevprop())) {
            gstring.append(",excludedRevprop:'").append(subversionSCM.getExcludedRevprop()).append("'");
        }
        if (StringUtils.isNotEmpty((CharSequence)subversionSCM.getExcludedUsers())) {
            gstring.append(",excludedUsers:'").append(subversionSCM.getExcludedUsers()).append("'");
        }
        gstring.append(",filterChangelog:").append(subversionSCM.isFilterChangelog());
        gstring.append(",ignoreDirPropChanges:").append(subversionSCM.isIgnoreDirPropChanges());
        if (StringUtils.isNotEmpty((CharSequence)subversionSCM.getIncludedRegions())) {
            gstring.append(",includedRegions:'").append(subversionSCM.getIncludedRegions()).append("'");
        }
        if (subversionSCM.getWorkspaceUpdater() != null) {
            gstring.append(",[$class:'").append(subversionSCM.getWorkspaceUpdater().getClass().getSimpleName()).append("']");
        }
        gstring.append(",locations:[");
        for (SubversionSCM.ModuleLocation moduleLocation : locations) {
            gstring.append("[");
            boolean empty = true;
            if (StringUtils.isNotEmpty((CharSequence)moduleLocation.credentialsId)) {
                gstring.append("credentialsId:'").append(moduleLocation.credentialsId).append("'");
                empty = false;
            }
            if (StringUtils.isNotEmpty((CharSequence)moduleLocation.depthOption)) {
                if (!empty) {
                    gstring.append(',');
                }
                gstring.append("depthOption: '").append(moduleLocation.depthOption).append("'");
                empty = false;
            }
            if (StringUtils.isNotEmpty((CharSequence)moduleLocation.getLocalDir())) {
                if (!empty) {
                    gstring.append(',');
                }
                gstring.append("local: '").append(moduleLocation.getLocalDir()).append("'");
            }
            if (StringUtils.isNotEmpty((CharSequence)moduleLocation.getURL())) {
                if (!empty) {
                    gstring.append(',');
                }
                gstring.append("remote: '").append(moduleLocation.getURL()).append("'");
            }
            gstring.append("]");
        }
        gstring.append("]");
        gstring.append("]");
        singleArgument.setValue(ModelASTValue.fromGString((String)gstring.toString(), (Object)((Object)this)));
        steps.add(checkout);
        ModelASTBranch branch = new ModelASTBranch((Object)this);
        branch.setSteps(steps);
        stage.setBranches(Arrays.asList(branch));
        ModelASTUtils.addStage((ModelASTPipelineDef)result.getModelASTPipelineDef(), (ModelASTStage)stage);
        return true;
    }
}

