/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.todeclarative.converter.jobproperty;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.BooleanParameterDefinition;
import hudson.model.ChoiceParameterDefinition;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.StringParameterDefinition;
import io.jenkins.plugins.todeclarative.converter.api.ConverterRequest;
import io.jenkins.plugins.todeclarative.converter.api.ConverterResult;
import io.jenkins.plugins.todeclarative.converter.api.ModelASTUtils;
import io.jenkins.plugins.todeclarative.converter.api.SingleTypedConverter;
import io.jenkins.plugins.todeclarative.converter.api.Warning;
import java.util.ArrayList;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTBuildParameter;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTBuildParameters;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTKeyValueOrMethodCallPair;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTPipelineDef;

@Extension
public class ParameterPropertyConverter
extends SingleTypedConverter<ParametersDefinitionProperty> {
    public boolean convert(ConverterRequest request, ConverterResult result, Object target) {
        ParametersDefinitionProperty parametersDefinitionProperty = (ParametersDefinitionProperty)target;
        if (parametersDefinitionProperty.getParameterDefinitions().isEmpty()) {
            return true;
        }
        ModelASTPipelineDef model = result.getModelASTPipelineDef();
        if (model.getParameters() == null) {
            model.setParameters(new ModelASTBuildParameters((Object)this));
        }
        int numWarnings = result.getWarnings().size();
        parametersDefinitionProperty.getParameterDefinitions().forEach(parameterDefinition -> {
            ModelASTBuildParameter parameter = this.build((ParameterDefinition)parameterDefinition, result);
            if (parameter != null) {
                ModelASTUtils.addParameter((ModelASTPipelineDef)model, (ModelASTBuildParameter)parameter);
            }
        });
        return result.getWarnings().size() <= numWarnings;
    }

    protected ModelASTBuildParameter build(ParameterDefinition parameterDefinition, ConverterResult converterResult) {
        ArrayList<ModelASTKeyValueOrMethodCallPair> args = new ArrayList<ModelASTKeyValueOrMethodCallPair>();
        if (StringParameterDefinition.class.getSimpleName().equals(parameterDefinition.getType())) {
            ModelASTBuildParameter parameter = new ModelASTBuildParameter((Object)this);
            parameter.setName("string");
            args.add(ModelASTUtils.buildKeyPairArg((String)"name", (Object)parameterDefinition.getName()));
            args.add(ModelASTUtils.buildKeyPairArg((String)"defaultValue", (Object)((StringParameterDefinition)parameterDefinition).getDefaultValue()));
            args.add(ModelASTUtils.buildKeyPairArg((String)"description", (Object)parameterDefinition.getDescription()));
            parameter.setArgs(args);
            return parameter;
        }
        if (ChoiceParameterDefinition.class.getSimpleName().equals(parameterDefinition.getType())) {
            ModelASTBuildParameter parameter = new ModelASTBuildParameter((Object)this);
            parameter.setName("choice");
            args.add(ModelASTUtils.buildKeyPairArg((String)"name", (Object)parameterDefinition.getName()));
            args.add(ModelASTUtils.buildKeyPairArg((String)"choices", (Object)((ChoiceParameterDefinition)parameterDefinition).getChoices()));
            args.add(ModelASTUtils.buildKeyPairArg((String)"description", (Object)parameterDefinition.getDescription()));
            parameter.setArgs(args);
            return parameter;
        }
        if (BooleanParameterDefinition.class.getSimpleName().equals(parameterDefinition.getType())) {
            ModelASTBuildParameter parameter = new ModelASTBuildParameter((Object)this);
            parameter.setName("booleanParam");
            args.add(ModelASTUtils.buildKeyPairArg((String)"name", (Object)parameterDefinition.getName()));
            args.add(ModelASTUtils.buildKeyPairArg((String)"defaultValue", (Object)this.getDefaultBooleanParameterValue((BooleanParameterDefinition)parameterDefinition)));
            args.add(ModelASTUtils.buildKeyPairArg((String)"description", (Object)parameterDefinition.getDescription()));
            parameter.setArgs(args);
            return parameter;
        }
        converterResult.addWarning(new Warning("Cannot convert property of type: " + parameterDefinition.getType(), parameterDefinition.getClass()));
        return null;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Superclass method is @CheckForNull, but subclass impl never returns null")
    private boolean getDefaultBooleanParameterValue(BooleanParameterDefinition def) {
        return def.getDefaultParameterValue().value;
    }
}

