/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.todeclarative.converter.buildwrapper;

import io.jenkins.plugins.todeclarative.converter.api.ConverterRequest;
import io.jenkins.plugins.todeclarative.converter.api.ConverterResult;
import io.jenkins.plugins.todeclarative.converter.api.SingleTypedConverter;
import org.jenkinsci.plugins.configfiles.buildwrapper.ConfigFileBuildWrapper;
import org.jenkinsci.plugins.configfiles.buildwrapper.ManagedFile;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTArgumentList;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTSingleArgument;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTTreeStep;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTValue;
import org.jenkinsci.plugins.variant.OptionalExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OptionalExtension(requirePlugins={"config-file-provider"})
public class ConfigFileBuildWrapperConverter
extends SingleTypedConverter<ConfigFileBuildWrapper> {
    private Logger LOGGER = LoggerFactory.getLogger(ConfigFileBuildWrapperConverter.class);

    public boolean convert(ConverterRequest request, ConverterResult result, Object target) {
        ConfigFileBuildWrapper configFileBuildWrapper = (ConfigFileBuildWrapper)target;
        if (configFileBuildWrapper.getManagedFiles() == null || configFileBuildWrapper.getManagedFiles().isEmpty()) {
            return true;
        }
        result.addWrappingTreeStep(() -> this.build(configFileBuildWrapper));
        return true;
    }

    private ModelASTTreeStep build(ConfigFileBuildWrapper configFileBuildWrapper) {
        ModelASTTreeStep configFileProvider = new ModelASTTreeStep((Object)this);
        configFileProvider.setName("configFileProvider");
        ModelASTSingleArgument singleArgument = new ModelASTSingleArgument(null);
        configFileProvider.setArgs((ModelASTArgumentList)singleArgument);
        ManagedFile managedFile = (ManagedFile)configFileBuildWrapper.getManagedFiles().get(0);
        StringBuilder gstring = new StringBuilder("[configFile(fileId:'");
        gstring.append(managedFile.getFileId());
        gstring.append("', targetLocation: '");
        gstring.append(managedFile.getTargetLocation());
        gstring.append("')]");
        singleArgument.setValue(ModelASTValue.fromGString((String)gstring.toString(), (Object)((Object)this)));
        return configFileProvider;
    }
}

