/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.todeclarative.converter.scm;

import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import io.jenkins.plugins.todeclarative.converter.api.ConverterRequest;
import io.jenkins.plugins.todeclarative.converter.api.ConverterResult;
import io.jenkins.plugins.todeclarative.converter.api.ModelASTUtils;
import io.jenkins.plugins.todeclarative.converter.api.SingleTypedConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTArgumentList;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTBranch;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTKey;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTNamedArgumentList;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTPipelineDef;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStage;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStep;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTValue;
import org.jenkinsci.plugins.variant.OptionalExtension;

@OptionalExtension(requirePlugins={"git"})
public class GitScmConverter
extends SingleTypedConverter<GitSCM> {
    public boolean convert(ConverterRequest request, ConverterResult result, Object target) {
        List repoList = ((GitSCM)target).getUserRemoteConfigs();
        if (repoList.isEmpty()) {
            return true;
        }
        ModelASTStage stage = new ModelASTStage((Object)this);
        stage.setName("Checkout Scm");
        ArrayList<ModelASTStep> steps = new ArrayList<ModelASTStep>();
        for (UserRemoteConfig userRemoteConfig : repoList) {
            ModelASTStep git = new ModelASTStep(null);
            git.setName("git");
            HashMap<ModelASTKey, ModelASTValue> args = new HashMap<ModelASTKey, ModelASTValue>();
            ModelASTKey url = new ModelASTKey((Object)this);
            url.setKey("url");
            ModelASTValue urlValue = ModelASTValue.fromConstant((Object)userRemoteConfig.getUrl(), (Object)((Object)this));
            args.put(url, urlValue);
            if (StringUtils.isNotBlank((CharSequence)userRemoteConfig.getRefspec())) {
                ModelASTKey branch = new ModelASTKey((Object)this);
                branch.setKey("branch");
                ModelASTValue branchValue = ModelASTValue.fromConstant((Object)userRemoteConfig.getRefspec(), (Object)((Object)this));
                args.put(branch, branchValue);
            }
            if (StringUtils.isNotBlank((CharSequence)userRemoteConfig.getCredentialsId())) {
                ModelASTKey credentialsId = new ModelASTKey((Object)this);
                credentialsId.setKey("credentialsId");
                ModelASTValue credentialsIdValue = ModelASTValue.fromConstant((Object)userRemoteConfig.getCredentialsId(), (Object)((Object)this));
                args.put(credentialsId, credentialsIdValue);
            }
            ModelASTNamedArgumentList stepArgs = new ModelASTNamedArgumentList(null);
            stepArgs.setArguments(args);
            git.setArgs((ModelASTArgumentList)stepArgs);
            steps.add(git);
        }
        ModelASTBranch branch = new ModelASTBranch((Object)this);
        branch.setSteps(steps);
        stage.setBranches(Arrays.asList(branch));
        ModelASTUtils.addStage((ModelASTPipelineDef)result.getModelASTPipelineDef(), (ModelASTStage)stage);
        return true;
    }
}

