/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.infrastructure.scanner.report.v1;

import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.AcceptedRiskReason;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.Architecture;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.EvaluationResult;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.Layer;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.OperatingSystem;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.Package;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.PackageType;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.Policy;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.PolicyBundle;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.PolicyBundleRule;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.ScanResult;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.ScanType;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.Severity;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.Vulnerability;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.scanner.report.v1.JsonInfo;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.scanner.report.v1.JsonLayer;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.scanner.report.v1.JsonPackage;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.scanner.report.v1.JsonResult;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.scanner.report.v1.JsonScanner;
import com.sysdig.jenkins.plugins.sysdig.infrastructure.scanner.report.v1.JsonVulnerability;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.Optional;

public record JsonScanResultV1(JsonInfo info, JsonScanner scanner, JsonResult result) {
    public Optional<ScanResult> toDomain() {
        if (this.result() == null) {
            return Optional.empty();
        }
        ScanResult scanResult = this.createScanResult();
        this.addLayersTo(scanResult);
        this.addRiskAcceptsTo(scanResult);
        this.addVulnerabilitiesTo(scanResult);
        this.addPackagesTo(scanResult);
        this.addPoliciesTo(scanResult);
        return Optional.of(scanResult);
    }

    private ScanResult createScanResult() {
        return new ScanResult(ScanType.Docker, this.result().metadata().pullString(), this.result().metadata().imageId(), this.result().metadata().digest(), new OperatingSystem(JsonScanResultV1.osFamilyFromString(this.result().metadata().os()), this.result().metadata().baseOs()), BigInteger.valueOf(this.result().metadata().size()), JsonScanResultV1.archFromString(this.result().metadata().architecture()), this.result().metadata().labels(), JsonScanResultV1.dateFromISO8601String(this.result().metadata().createdAt()));
    }

    private void addLayersTo(ScanResult scanResult) {
        this.result().layers().values().stream().filter(jsonLayer -> !jsonLayer.digest().isBlank()).forEach(jsonLayer -> scanResult.addLayer(jsonLayer.digest(), BigInteger.valueOf(jsonLayer.size()), jsonLayer.command()));
    }

    private void addRiskAcceptsTo(ScanResult scanResult) {
        this.result().riskAccepts().values().stream().forEach(jsonRisk -> scanResult.addAcceptedRisk(jsonRisk.id(), JsonScanResultV1.acceptedRiskReasonFromString(jsonRisk.reason()), jsonRisk.description(), jsonRisk.expirationDateOpt().map(JsonScanResultV1::dateFromShortString).orElse(null), "active".equalsIgnoreCase(jsonRisk.status()), JsonScanResultV1.dateFromISO8601String(jsonRisk.createdAt()), JsonScanResultV1.dateFromISO8601String(jsonRisk.updatedAt())));
    }

    private void addVulnerabilitiesTo(ScanResult scanResult) {
        this.result().vulnerabilities().values().forEach(jsonVuln -> {
            Vulnerability vuln = scanResult.addVulnerability(jsonVuln.name(), JsonScanResultV1.severityFromString(jsonVuln.severity()), JsonScanResultV1.dateFromShortString(jsonVuln.disclosureDate()), jsonVuln.optSolutionDate().map(JsonScanResultV1::dateFromShortString).orElse(null), jsonVuln.exploitable(), jsonVuln.fixVersion());
            jsonVuln.riskAcceptRefs().stream().map(jsonRiskRef -> this.result().riskAccepts().get(jsonRiskRef)).map(jsonRisk -> scanResult.findAcceptedRiskByID(jsonRisk.id()).get()).forEach(vuln::addAcceptedRisk);
        });
    }

    private void addPackagesTo(ScanResult scanResult) {
        this.result().packages().values().stream().forEach(jsonPkg -> {
            JsonLayer jsonLayer = this.result().layers().get(jsonPkg.layerRef());
            Layer layerWhereThisPackageIsFound = scanResult.findLayerByDigest(jsonLayer.digest()).get();
            Package addedPackage = scanResult.addPackage(JsonScanResultV1.packageTypeFromString(jsonPkg.type()), jsonPkg.name(), jsonPkg.version(), jsonPkg.path(), layerWhereThisPackageIsFound);
            jsonPkg.vulnerabilitiesRefs().stream().map(jsonVulnRef -> this.result().vulnerabilities().get(jsonVulnRef)).map(jsonVuln -> scanResult.findVulnerabilityByCVE(jsonVuln.name()).get()).forEach(addedPackage::addVulnerabilityFound);
            jsonPkg.vulnerabilitiesRefs().stream().map(jsonVulnRef -> this.result().vulnerabilities().get(jsonVulnRef)).flatMap(jsonVuln -> jsonVuln.riskAcceptRefs().stream()).map(jsonRiskRef -> this.result().riskAccepts().get(jsonRiskRef)).map(jsonRisk -> scanResult.findAcceptedRiskByID(jsonRisk.id()).get()).forEach(addedPackage::addAcceptedRisk);
        });
    }

    private void addPoliciesTo(ScanResult scanResult) {
        this.result().policies().evaluations().stream().forEach(jsonPolicy -> {
            Policy policy = scanResult.addPolicy(jsonPolicy.identifier(), jsonPolicy.name(), JsonScanResultV1.dateFromISO8601String(jsonPolicy.createdAt()), JsonScanResultV1.dateFromISO8601String(jsonPolicy.updatedAt()));
            jsonPolicy.bundles().stream().forEach(jsonBundle -> {
                PolicyBundle policyBundle = scanResult.addPolicyBundle(jsonBundle.identifier(), jsonBundle.name(), policy);
                jsonBundle.rules().stream().forEach(jsonRule -> {
                    PolicyBundleRule rule = policyBundle.addRule(jsonRule.ruleId(), jsonRule.description(), jsonRule.evaluationResult().equalsIgnoreCase("failed") ? EvaluationResult.Failed : EvaluationResult.Passed);
                    jsonRule.failures().stream().forEach(jsonFailure -> {
                        switch (jsonRule.failureType()) {
                            case "imageConfigFailure": {
                                rule.addImageConfigFailure(jsonFailure.remediation());
                                break;
                            }
                            case "pkgVulnFailure": {
                                rule.addPkgVulnFailure(this.failureMessageFor(jsonFailure.packageRef(), jsonFailure.vulnerabilityRef()));
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected value: " + jsonRule.failureType());
                            }
                        }
                    });
                });
            });
        });
    }

    private String failureMessageFor(String jsonPackageRef, String jsonVulnerabilityRef) {
        JsonPackage jsonPackage = this.result().packages().get(jsonPackageRef);
        JsonVulnerability jsonVulnerability = this.result().vulnerabilities().get(jsonVulnerabilityRef);
        return "%s found in %s (%s)".formatted(jsonVulnerability.name(), jsonPackage.name(), jsonPackage.version());
    }

    private static Date dateFromShortString(@NonNull String str) {
        return Date.from(LocalDate.parse(str).atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    private static Date dateFromISO8601String(@NonNull String str) {
        return Date.from(Instant.parse(str));
    }

    private static Severity severityFromString(String severityString) {
        return switch (severityString.toLowerCase()) {
            case "critical" -> Severity.Critical;
            case "high" -> Severity.High;
            case "medium" -> Severity.Medium;
            case "low" -> Severity.Low;
            case "negligible" -> Severity.Negligible;
            default -> Severity.Unknown;
        };
    }

    private static AcceptedRiskReason acceptedRiskReasonFromString(String reasonString) {
        return switch (reasonString) {
            case "RiskOwned" -> AcceptedRiskReason.RiskOwned;
            case "RiskTransferred" -> AcceptedRiskReason.RiskTransferred;
            case "RiskAvoided" -> AcceptedRiskReason.RiskAvoided;
            case "RiskMitigated" -> AcceptedRiskReason.RiskMitigated;
            case "RiskNotRelevant" -> AcceptedRiskReason.RiskNotRelevant;
            case "Custom" -> AcceptedRiskReason.Custom;
            default -> AcceptedRiskReason.Unknown;
        };
    }

    private static Architecture archFromString(String architecture) {
        return switch (architecture.toLowerCase()) {
            case "amd64" -> Architecture.AMD64;
            case "arm64" -> Architecture.ARM64;
            default -> Architecture.Unknown;
        };
    }

    private static PackageType packageTypeFromString(String string) {
        return switch (string) {
            case "C#" -> PackageType.CSharp;
            case "golang" -> PackageType.Golang;
            case "java" -> PackageType.Java;
            case "javascript" -> PackageType.Javascript;
            case "os" -> PackageType.OS;
            case "php" -> PackageType.PHP;
            case "python" -> PackageType.Python;
            case "ruby" -> PackageType.Ruby;
            case "rust" -> PackageType.Rust;
            default -> PackageType.Unknown;
        };
    }

    private static OperatingSystem.Family osFamilyFromString(String os) {
        return switch (os.toLowerCase()) {
            case "linux" -> OperatingSystem.Family.Linux;
            case "darwin" -> OperatingSystem.Family.Darwin;
            case "windows" -> OperatingSystem.Family.Windows;
            default -> OperatingSystem.Family.Unknown;
        };
    }
}

