/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.infrastructure.scanner;

import com.sysdig.jenkins.plugins.sysdig.domain.SysdigLogger;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class LogOutputStreamAdapter
extends OutputStream {
    private final SysdigLogger logger;
    private final StringBuilder buffer = new StringBuilder();
    private final String newline = System.lineSeparator();

    public LogOutputStreamAdapter(SysdigLogger logger) {
        this.logger = logger;
    }

    @Override
    public void write(int b) {
        this.buffer.append((char)b);
        this.checkForNewline();
    }

    @Override
    public void write(@NonNull byte[] b, int off, int len) {
        this.buffer.append(new String(b, off, len, StandardCharsets.UTF_8));
        this.checkForNewline();
    }

    private void checkForNewline() {
        int newlineIndex;
        while ((newlineIndex = this.buffer.indexOf(this.newline)) != -1) {
            String line = this.buffer.substring(0, newlineIndex);
            this.logger.logInfo(line);
            this.buffer.delete(0, newlineIndex + this.newline.length());
        }
    }

    @Override
    public void flush() {
        if (!this.buffer.isEmpty()) {
            this.logger.logInfo(this.buffer.toString());
            this.buffer.setLength(0);
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        super.close();
    }
}

