/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult;

import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.EvaluationResult;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.PolicyBundle;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.PolicyBundleRuleFailure;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.PolicyBundleRuleImageConfigFailure;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.PolicyBundleRulePkgVulnFailure;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class PolicyBundleRule
implements Serializable {
    private final String id;
    private final String description;
    private final EvaluationResult evaluationResult;
    private final PolicyBundle parent;
    private final List<PolicyBundleRuleFailure> failures;

    PolicyBundleRule(String id, String description, EvaluationResult evaluationResult, PolicyBundle parent) {
        this.id = id;
        this.description = description;
        this.evaluationResult = evaluationResult;
        this.parent = parent;
        this.failures = new ArrayList<PolicyBundleRuleFailure>();
    }

    public String id() {
        return this.id;
    }

    public String description() {
        return this.description;
    }

    public EvaluationResult evaluationResult() {
        return this.evaluationResult;
    }

    public PolicyBundle parent() {
        return this.parent;
    }

    public PolicyBundleRuleImageConfigFailure addImageConfigFailure(String remediation) {
        PolicyBundleRuleImageConfigFailure failure = new PolicyBundleRuleImageConfigFailure(remediation, this);
        this.failures.add(failure);
        return failure;
    }

    public PolicyBundleRulePkgVulnFailure addPkgVulnFailure(String description) {
        PolicyBundleRulePkgVulnFailure failure = new PolicyBundleRulePkgVulnFailure(description, this);
        this.failures.add(failure);
        return failure;
    }

    public List<PolicyBundleRuleFailure> failures() {
        return Collections.unmodifiableList(this.failures);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyBundleRule that = (PolicyBundleRule)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.description, that.description) && this.evaluationResult == that.evaluationResult;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.description, this.evaluationResult);
    }
}

