/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult;

import com.sysdig.jenkins.plugins.sysdig.domain.AggregateChild;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.AcceptedRisk;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.Layer;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.PackageType;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.ScanResult;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.Vulnerability;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Package
implements AggregateChild<ScanResult>,
Serializable {
    private final PackageType type;
    private final String name;
    private final String version;
    private final String path;
    private final Layer foundInLayer;
    private final Set<Vulnerability> vulnerabilities;
    private final Set<AcceptedRisk> acceptedRisks;
    private final ScanResult root;

    Package(PackageType type, String name, String version, String path, Layer foundInLayer, ScanResult root) {
        this.type = type;
        this.name = name;
        this.version = version;
        this.path = path;
        this.foundInLayer = foundInLayer;
        this.root = root;
        this.vulnerabilities = new HashSet<Vulnerability>();
        this.acceptedRisks = new HashSet<AcceptedRisk>();
    }

    public PackageType type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String version() {
        return this.version;
    }

    public String path() {
        return this.path;
    }

    public Layer foundInLayer() {
        return this.foundInLayer;
    }

    public void addVulnerabilityFound(Vulnerability vulnerability) {
        if (this.vulnerabilities.add(vulnerability)) {
            vulnerability.addFoundInPackage(this);
        }
    }

    public Set<Vulnerability> vulnerabilities() {
        return Collections.unmodifiableSet(this.vulnerabilities);
    }

    public void addAcceptedRisk(AcceptedRisk acceptedRisk) {
        if (this.acceptedRisks.add(acceptedRisk)) {
            acceptedRisk.addForPackage(this);
        }
    }

    public Set<AcceptedRisk> acceptedRisks() {
        return Collections.unmodifiableSet(this.acceptedRisks);
    }

    @Override
    public ScanResult root() {
        return this.root;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Package aPackage = (Package)o;
        return this.type == aPackage.type && Objects.equals(this.name, aPackage.name) && Objects.equals(this.version, aPackage.version) && Objects.equals(this.path, aPackage.path);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name, this.version, this.path);
    }
}

