/*
 * Decompiled with CFR 0.152.
 */
package com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult;

import com.sysdig.jenkins.plugins.sysdig.domain.AggregateChild;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.AcceptedRiskReason;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.Package;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.ScanResult;
import com.sysdig.jenkins.plugins.sysdig.domain.vm.scanresult.Vulnerability;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class AcceptedRisk
implements AggregateChild<ScanResult>,
Serializable {
    private final String id;
    private final AcceptedRiskReason reason;
    private final String description;
    private final Date expirationDate;
    private final boolean isActive;
    private final Date createdAt;
    private final Date updatedAt;
    private final Set<Vulnerability> assignedToVulnerabilities;
    private final Set<Package> assignedToPackages;
    private final ScanResult root;

    public AcceptedRisk(String id, AcceptedRiskReason reason, String description, Date expirationDate, boolean isActive, Date createdAt, Date updatedAt, ScanResult root) {
        this.id = id;
        this.reason = reason;
        this.description = description;
        this.expirationDate = expirationDate;
        this.isActive = isActive;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.assignedToVulnerabilities = new HashSet<Vulnerability>();
        this.assignedToPackages = new HashSet<Package>();
        this.root = root;
    }

    public String id() {
        return this.id;
    }

    public AcceptedRiskReason reason() {
        return this.reason;
    }

    public String description() {
        return this.description;
    }

    public Optional<Date> expirationDate() {
        return Optional.ofNullable(this.expirationDate);
    }

    public boolean isActive() {
        return this.isActive;
    }

    public Date createdAt() {
        return this.createdAt;
    }

    public Date updatedAt() {
        return this.updatedAt;
    }

    public void addForVulnerability(Vulnerability vulnerability) {
        if (this.assignedToVulnerabilities.add(vulnerability)) {
            vulnerability.addAcceptedRisk(this);
        }
    }

    public Set<Vulnerability> assignedToVulnerabilities() {
        return Collections.unmodifiableSet(this.assignedToVulnerabilities);
    }

    public void addForPackage(Package aPackage) {
        if (this.assignedToPackages.add(aPackage)) {
            aPackage.addAcceptedRisk(this);
        }
    }

    public Set<Package> assignedToPackages() {
        return Collections.unmodifiableSet(this.assignedToPackages);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcceptedRisk that = (AcceptedRisk)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    @Override
    public ScanResult root() {
        return this.root;
    }
}

