/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sshsteps.util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.slf4j.MDC;

public class CustomLogHandler
extends Handler {
    private static final int DEFAULT_BUFFER_SIZE = 50;
    private static final long DEFAULT_FLUSH_INTERVAL_MS = 100L;
    private static final long DEFAULT_RATE_LIMIT_LINES_PER_SEC = 1000L;
    private final PrintStream logger;
    private String uuid;
    private final List<String> buffer;
    private final int bufferSize;
    private final long flushIntervalMs;
    private final long rateLimitLinesPerSec;
    private long lastFlushTime;
    private final AtomicLong lineCount = new AtomicLong(0L);
    private long lastRateLimitReset;

    public CustomLogHandler(PrintStream logger, String uuid) {
        this(logger, uuid, 50, 100L, 1000L);
    }

    public CustomLogHandler(PrintStream logger, String uuid, int bufferSize, long flushIntervalMs, long rateLimitLinesPerSec) {
        this.logger = logger;
        this.uuid = uuid;
        this.bufferSize = bufferSize;
        this.flushIntervalMs = flushIntervalMs;
        this.rateLimitLinesPerSec = rateLimitLinesPerSec;
        this.buffer = new ArrayList<String>(bufferSize);
        this.lastFlushTime = System.currentTimeMillis();
        this.lastRateLimitReset = System.currentTimeMillis();
    }

    @Override
    public synchronized void publish(LogRecord record) {
        long currentTime;
        String currentUuid;
        if (this.uuid == null) {
            this.uuid = MDC.get((String)"execution.id");
        }
        if (!Objects.equals(this.uuid, currentUuid = MDC.get((String)"execution.id"))) {
            return;
        }
        if (this.rateLimitLinesPerSec > 0L) {
            long currentCount;
            currentTime = System.currentTimeMillis();
            if (currentTime - this.lastRateLimitReset >= 1000L) {
                this.lineCount.set(0L);
                this.lastRateLimitReset = currentTime;
            }
            if ((currentCount = this.lineCount.incrementAndGet()) > this.rateLimitLinesPerSec) {
                if (currentCount == this.rateLimitLinesPerSec + 1L) {
                    this.buffer.add("[Rate limit exceeded: some output suppressed]");
                }
                return;
            }
        }
        this.buffer.add(record.getMessage());
        currentTime = System.currentTimeMillis();
        if (this.buffer.size() >= this.bufferSize || currentTime - this.lastFlushTime >= this.flushIntervalMs) {
            this.flushBuffer();
            this.lastFlushTime = currentTime;
        }
    }

    private void flushBuffer() {
        if (!this.buffer.isEmpty()) {
            for (String message : this.buffer) {
                this.logger.println(message);
            }
            this.logger.flush();
            this.buffer.clear();
        }
    }

    @Override
    public synchronized void flush() {
        this.flushBuffer();
    }

    @Override
    public synchronized void close() throws SecurityException {
        this.flushBuffer();
    }
}

