/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar.client;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.plugins.sonar.client.HttpClient;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.apache.commons.lang3.StringUtils;

public class WsClient {
    private static final String STATUS_ATTR = "status";
    public static final String API_PROJECT_STATUS_WITH_ANALYSISID = "/api/qualitygates/project_status?analysisId=";
    public static final String API_VERSION = "/api/server/version";
    public static final String API_CE_TASK = "/api/ce/task?id=";
    private final HttpClient client;
    private final String serverUrl;
    private final String token;

    public WsClient(HttpClient client, String serverUrl, @Nullable String token) {
        this.client = client;
        this.serverUrl = StringUtils.removeEnd((String)serverUrl, (String)"/");
        this.token = token;
    }

    public CETask getCETask(String taskId) {
        String url = this.serverUrl + API_CE_TASK + taskId;
        String text = this.client.getHttp(url, this.token);
        try {
            JSONObject json = (JSONObject)JSONSerializer.toJSON((Object)text);
            JSONObject task = json.getJSONObject("task");
            String status = task.getString(STATUS_ATTR);
            String componentName = task.getString("componentName");
            String componentKey = task.getString("componentKey");
            String analysisId = task.optString("analysisId", null);
            return new CETask(status, componentName, componentKey, url, analysisId);
        }
        catch (JSONException e) {
            throw new IllegalStateException("Unable to parse response from " + url + ":\n" + text, e);
        }
    }

    public String requestQualityGateStatus(String analysisId) {
        String url = this.serverUrl + API_PROJECT_STATUS_WITH_ANALYSISID + WsClient.encode(analysisId);
        String text = this.client.getHttp(url, this.token);
        try {
            JSONObject json = (JSONObject)JSONSerializer.toJSON((Object)text);
            JSONObject projectStatus = json.getJSONObject("projectStatus");
            return projectStatus.getString(STATUS_ATTR);
        }
        catch (JSONException e) {
            throw new IllegalStateException("Unable to parse response from " + url + ":\n" + text, e);
        }
    }

    public String getServerVersion() {
        return this.client.getHttp(this.serverUrl + API_VERSION, null);
    }

    private static String encode(String param) {
        return URLEncoder.encode(param, StandardCharsets.UTF_8);
    }

    public static class CETask {
        public static final String STATUS_SUCCESS = "SUCCESS";
        public static final String STATUS_FAILURE = "FAILED";
        public static final String STATUS_CANCELED = "CANCELED";
        private final String status;
        private final String componentName;
        private final String componentKey;
        private final String url;
        private final String analysisId;

        public CETask(String status, String componentName, String componentKey, String ceUrl, @Nullable String analysisId) {
            this.status = status;
            this.componentName = componentName;
            this.componentKey = componentKey;
            this.url = ceUrl;
            this.analysisId = analysisId;
        }

        public String getUrl() {
            return this.url;
        }

        public String getStatus() {
            return this.status;
        }

        public String getComponentName() {
            return this.componentName;
        }

        public String getComponentKey() {
            return this.componentKey;
        }

        @CheckForNull
        public String getAnalysisId() {
            return this.analysisId;
        }
    }
}

