/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sonar.configurationslicing;

import configurationslicing.UnorderedStringSlicer;
import hudson.model.AbstractProject;
import hudson.plugins.sonar.SonarPublisher;
import hudson.plugins.sonar.utils.Logger;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractSonarPublisherSlicerSpec
extends UnorderedStringSlicer.UnorderedStringSlicerSpec<AbstractProject<?, ?>> {
    protected abstract String getDefaultValue();

    public List<AbstractProject<?, ?>> getWorkDomain() {
        ArrayList workDomain = new ArrayList();
        for (AbstractProject item : Jenkins.get().getItems(AbstractProject.class)) {
            if (AbstractSonarPublisherSlicerSpec.getSonarPublisher(item) == null) continue;
            workDomain.add(item);
        }
        return workDomain;
    }

    public String getName(AbstractProject<?, ?> project) {
        return project.getFullName();
    }

    public String getDefaultValueString() {
        return this.getDefaultValue();
    }

    private static SonarPublisher getSonarPublisher(AbstractProject<?, ?> project) {
        for (Publisher publisher : project.getPublishersList()) {
            if (!(publisher instanceof SonarPublisher)) continue;
            return (SonarPublisher)publisher;
        }
        return null;
    }

    public final List<String> getValues(AbstractProject<?, ?> project) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(this.doGetValue(AbstractSonarPublisherSlicerSpec.getSonarPublisher(project)));
        return values;
    }

    protected abstract String doGetValue(SonarPublisher var1);

    public final boolean setValues(AbstractProject<?, ?> project, List<String> list) {
        if (list.isEmpty()) {
            return false;
        }
        this.doSetValue(AbstractSonarPublisherSlicerSpec.getSonarPublisher(project), list.iterator().next());
        try {
            project.save();
        }
        catch (IOException e) {
            Logger.LOG.throwing(((Object)((Object)this)).getClass().getName(), "setValues", e);
            return false;
        }
        return true;
    }

    protected abstract void doSetValue(SonarPublisher var1, String var2);

    protected String defaultValueIfBlank(String value) {
        return StringUtils.isBlank((String)value) ? this.getDefaultValue() : value;
    }

    protected String nullIfDefaultValue(String value) {
        return this.getDefaultValue().equals(value) ? null : value;
    }
}

