/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sauce_ondemand;

import com.saucelabs.saucerest.DataCenter;
import com.saucelabs.saucerest.api.JobsEndpoint;
import com.saucelabs.saucerest.model.jobs.Job;
import hudson.plugins.sauce_ondemand.JenkinsJobInformation;
import hudson.plugins.sauce_ondemand.JenkinsSauceREST;
import hudson.plugins.sauce_ondemand.credentials.SauceCredentials;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.json.JSONException;

public class SauceTestResultsById {
    private static final Logger logger = Logger.getLogger(SauceTestResultsById.class.getName());
    private final String id;
    private final SauceCredentials credentials;
    private final JenkinsJobInformation job;
    private final String server;

    public SauceTestResultsById(String id, SauceCredentials credentials, JenkinsSauceREST sauceREST) {
        this.id = id;
        this.credentials = credentials;
        this.job = new JenkinsJobInformation(id, credentials.getHMAC(id));
        this.server = credentials.getRestEndpoint().replace("https://", "https://app.");
        JobsEndpoint jobs = sauceREST.getJobsEndpoint();
        try {
            Job job = jobs.getJobDetails(id);
            this.job.populate(job);
        }
        catch (IOException | JSONException e) {
            logger.log(Level.WARNING, "Unable to retrieve Job data from Sauce Labs", e);
        }
    }

    public SauceTestResultsById(String id, SauceCredentials credentials) {
        this(id, credentials, new JenkinsSauceREST(credentials.getUsername(), credentials.getPassword().getPlainText(), DataCenter.fromString((String)credentials.getRestEndpointName()), Jenkins.get().getProxy()));
    }

    public String getId() {
        return this.id;
    }

    public String getAuth() throws IOException {
        return this.credentials.getHMAC(this.id);
    }

    public String getServer() {
        return this.server;
    }

    public String getName() {
        return this.job.getName();
    }

    public boolean hasFailureMessage() {
        return this.job.hasFailureMessage();
    }

    public String getFailureMessage() {
        return this.job.getFailureMessage();
    }

    public String getJobId() {
        return this.job.getJobId();
    }
}

