/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sauce_ondemand;

import com.saucelabs.ci.JobInformation;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.plugins.sauce_ondemand.JenkinsJobInformation;
import hudson.plugins.sauce_ondemand.SauceOnDemandBuildAction;
import hudson.plugins.sauce_ondemand.SauceOnDemandReport;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.TestObject;
import hudson.tasks.junit.TestResultAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SauceOnDemandReportFactory
extends TestResultAction.Data {
    private static final Logger logger = Logger.getLogger(SauceOnDemandReportFactory.class.getName());
    public static final SauceOnDemandReportFactory INSTANCE = new SauceOnDemandReportFactory();
    private static final String JOB_NAME_PATTERN = "(" + Pattern.quote("{0}") + ")$";

    public Object readResolve() {
        return INSTANCE;
    }

    public List<SauceOnDemandReport> getTestAction(TestObject testObject) {
        if (testObject instanceof CaseResult) {
            CaseResult cr = (CaseResult)testObject;
            ArrayList<String[]> ids = new ArrayList<String[]>();
            logger.log(Level.FINE, "Attempting to find Sauce SessionID for test object: " + cr.getFullName());
            logger.log(Level.FINER, "Test object display name: " + cr.getDisplayName());
            AbstractBuild build = cr.getOwner();
            SauceOnDemandBuildAction buildAction = SauceOnDemandBuildAction.getSauceBuildAction((Run)build);
            if (buildAction == null) {
                logger.log(Level.FINER, "Unable to get build action from caseresult owner, try using run instead");
                buildAction = SauceOnDemandBuildAction.getSauceBuildAction(cr.getRun());
            }
            if (buildAction != null) {
                List<JenkinsJobInformation> jobs = buildAction.getJobs();
                for (JobInformation jobInformation : jobs) {
                    if (jobInformation.getName() == null) continue;
                    if (SauceOnDemandReportFactory.matchTestNames(jobInformation.getName(), cr.getFullName(), cr.getDisplayName())) {
                        logger.log(Level.FINER, "Checking if job name matches test object: " + jobInformation.getName() + " [TRUE]");
                        ids.add(new String[]{jobInformation.getJobId(), jobInformation.getHmac()});
                        continue;
                    }
                    logger.log(Level.FINER, "Checking if job name matches test object: " + jobInformation.getName() + " [FALSE]");
                }
            } else {
                logger.log(Level.FINE, "Unable to get build action");
            }
            if (ids.isEmpty()) {
                logger.log(Level.FINE, "No Sauce SessionIDs found for test object via build action name matching, adding Sauce SessionIDs by parsing results");
                ids.addAll(SauceOnDemandReportFactory.findSessionIDs(cr, cr.getStdout(), cr.getStderr()));
            }
            if (ids.isEmpty()) {
                logger.log(Level.WARNING, "Unable to find Sauce SessionID for test object");
            }
            if (!ids.isEmpty()) {
                logger.log(Level.FINE, "Final number of Sauce SessionIDs found: " + ids.size());
                return Collections.singletonList(new SauceOnDemandReport(buildAction, ids));
            }
        } else {
            logger.log(Level.FINE, "Test Object not a CaseResult, unable to parse output: " + testObject.toString());
        }
        return Collections.emptyList();
    }

    public static List<String[]> findSessionIDs(CaseResult cr, String ... output) {
        logger.log(Level.FINE, cr == null ? "Parsing Sauce Session ids in stdout" : "Parsing Sauce Session ids in test results");
        ArrayList<String[]> sessions = new ArrayList<String[]>();
        ArrayList<String[]> matchedSessions = new ArrayList<String[]>();
        for (String text : output) {
            if (text == null) continue;
            Matcher m = SauceOnDemandBuildAction.SESSION_ID_PATTERN.matcher(text);
            while (m.find()) {
                String sessionId = m.group(1);
                String job = "";
                if (m.groupCount() == 2) {
                    job = m.group(2);
                }
                if (cr == null) {
                    sessions.add(new String[]{sessionId, job});
                    continue;
                }
                if (SauceOnDemandReportFactory.matchTestNames(job, cr.getFullName(), cr.getDisplayName())) {
                    matchedSessions.add(new String[]{sessionId, job, String.valueOf(cr.isPassed())});
                    logger.log(Level.FINER, "Checking if job name matches test object: " + job + " [TRUE]");
                    continue;
                }
                sessions.add(new String[]{sessionId, job, String.valueOf(cr.isPassed())});
                logger.log(Level.FINER, "Checking if job name matches test object: " + job + " [FALSE]");
            }
        }
        logger.log(Level.FINER, "Sauce SessionIDs with matching job names: " + matchedSessions.size());
        logger.log(Level.FINER, "Sauce SessionIDs without matching job names: " + sessions.size());
        if (!matchedSessions.isEmpty()) {
            return matchedSessions;
        }
        return sessions;
    }

    public static boolean matchTestNames(String jobName, String fullName, String displayName) {
        Pattern jobNamePattern = Pattern.compile(MessageFormat.format(JOB_NAME_PATTERN, jobName));
        Matcher matcher = jobNamePattern.matcher(fullName);
        return jobName.equals(fullName) || jobName.contains(displayName) || matcher.find();
    }
}

