/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sauce_ondemand;

import hudson.plugins.sauce_ondemand.SauceOnDemandBuildAction;
import hudson.tasks.junit.TestAction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class SauceOnDemandReport
extends TestAction {
    private static final Logger logger = Logger.getLogger(SauceOnDemandReport.class.getName());
    private final List<String[]> sessionIds;
    @Deprecated
    private final String userName;
    @Deprecated
    private final String apiKey;
    private final String server;

    public SauceOnDemandReport(SauceOnDemandBuildAction buildAction, List<String[]> ids) {
        this.userName = null;
        this.apiKey = null;
        this.server = this.getBuildActionServer(buildAction);
        this.sessionIds = ids;
    }

    public String getBuildActionServer(SauceOnDemandBuildAction buildAction) {
        if (buildAction != null) {
            return buildAction.getCredentials().getRestEndpoint().replace("https://", "https://app.");
        }
        return "https://apps.saucelabs.com/";
    }

    public List<String[]> getIDs() {
        ArrayList<String[]> ids = new ArrayList<String[]>();
        for (String[] sessionId : this.sessionIds) {
            ids.add(sessionId);
        }
        logger.fine("Retrieving Sauce job ids, found " + ((Object)ids).toString());
        return Collections.unmodifiableList(ids);
    }

    public String getId() {
        return this.getIDs().get(0)[0];
    }

    public String getAuth() throws IOException {
        return this.getIDs().get(0)[1];
    }

    public String getServer() {
        return this.server;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return null;
    }
}

