/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sauce_ondemand;

import com.saucelabs.ci.JobInformation;
import com.saucelabs.saucerest.DataCenter;
import com.saucelabs.saucerest.JobSource;
import com.saucelabs.saucerest.api.BuildsEndpoint;
import com.saucelabs.saucerest.api.JobsEndpoint;
import com.saucelabs.saucerest.model.builds.Build;
import com.saucelabs.saucerest.model.builds.JobInBuild;
import com.saucelabs.saucerest.model.builds.JobsInBuild;
import com.saucelabs.saucerest.model.builds.LookupBuildsParameters;
import com.saucelabs.saucerest.model.builds.LookupJobsParameters;
import hudson.Util;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.sauce_ondemand.AbstractAction;
import hudson.plugins.sauce_ondemand.JenkinsBuildInformation;
import hudson.plugins.sauce_ondemand.JenkinsJobInformation;
import hudson.plugins.sauce_ondemand.JenkinsSauceREST;
import hudson.plugins.sauce_ondemand.SauceEnvironmentUtil;
import hudson.plugins.sauce_ondemand.SauceOnDemandBuildWrapper;
import hudson.plugins.sauce_ondemand.SauceOnDemandProjectAction;
import hudson.plugins.sauce_ondemand.SauceTestResultsById;
import hudson.plugins.sauce_ondemand.StopJobThread;
import hudson.plugins.sauce_ondemand.credentials.SauceCredentials;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.Jenkins;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;
import jenkins.util.Timer;
import org.json.JSONException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class SauceOnDemandBuildAction
extends AbstractAction
implements Serializable,
RunAction2,
SimpleBuildStep.LastBuildAction {
    public static final Pattern SESSION_ID_PATTERN = Pattern.compile("SauceOnDemandSessionID=([0-9a-fA-F]+)(?:.job-name=(.*))?");
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(SauceOnDemandBuildAction.class.getName());
    private transient Run build;
    private List<JenkinsJobInformation> jobInformation;
    private JenkinsBuildInformation buildInformation;
    @Deprecated
    private String accessKey;
    @Deprecated
    private String username;
    private String credentialsId;
    private String restEndpoint;

    @DataBoundConstructor
    public SauceOnDemandBuildAction(Run build, String credentialsId) {
        this.credentialsId = credentialsId;
        this.build = build;
    }

    public static JenkinsBuildInformation retrieveBuildFromSauce(JenkinsSauceREST sauceREST, String buildNumber) throws JSONException {
        logger.fine("Performing Sauce REST retrieve results for " + buildNumber);
        int retries = 0;
        int maxRetries = 1;
        String jsonResponse = "";
        while (retries < maxRetries && "".equals(jsonResponse)) {
            try {
                JenkinsBuildInformation buildInformation = SauceOnDemandBuildAction.retrieveBuildInformationFromSauce(sauceREST, buildNumber);
                if (!"".equals(buildInformation.getBuildId())) {
                    return buildInformation;
                }
            }
            catch (Exception e) {
                jsonResponse = "";
            }
            logger.log(Level.WARNING, "Sauce REST API get build JSON Response was empty or threw an exception for " + buildNumber + ", waiting and retrying");
            ++retries;
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return new JenkinsBuildInformation("");
    }

    public static JenkinsBuildInformation retrieveBuildInformationFromSauce(JenkinsSauceREST sauceREST, String buildNumber) throws JSONException, IOException {
        logger.fine("Performing Sauce REST retrieve results for " + buildNumber);
        BuildsEndpoint buildsEndpoint = sauceREST.getBuildsEndpoint();
        LookupBuildsParameters parameters = new LookupBuildsParameters.Builder().setName(buildNumber).setLimit(Integer.valueOf(1)).build();
        List builds = buildsEndpoint.lookupBuilds(JobSource.VDC, parameters);
        if (builds == null || builds.isEmpty()) {
            logger.warning("Unable to find build for name: `" + buildNumber + "`");
            return new JenkinsBuildInformation("");
        }
        return new JenkinsBuildInformation((Build)builds.get(0));
    }

    public static LinkedHashMap<String, JenkinsJobInformation> retrieveJobIdsFromSauce(JenkinsSauceREST sauceREST, Run build) throws JSONException, IOException {
        SauceCredentials credentials = SauceOnDemandBuildAction.getSauceBuildAction(build).getCredentials();
        return SauceOnDemandBuildAction.retrieveJobIdsFromSauce(sauceREST, build, credentials);
    }

    public static SauceOnDemandBuildAction getSauceBuildAction(Run build) {
        MavenModuleSetBuild mb;
        if (build == null) {
            return null;
        }
        SauceOnDemandBuildAction buildAction = (SauceOnDemandBuildAction)build.getAction(SauceOnDemandBuildAction.class);
        if (buildAction == null && build instanceof MavenBuild && (mb = ((MavenBuild)build).getParentBuild()) != null) {
            buildAction = (SauceOnDemandBuildAction)mb.getAction(SauceOnDemandBuildAction.class);
        }
        return buildAction;
    }

    public static LinkedHashMap<String, JenkinsJobInformation> retrieveJobIdsFromSauce(JenkinsSauceREST sauceREST, Run build, SauceCredentials credentials) throws JSONException, IOException {
        LinkedHashMap<String, JenkinsJobInformation> jobInformation = new LinkedHashMap<String, JenkinsJobInformation>();
        String buildNumber = SauceEnvironmentUtil.getSanitizedBuildNumber(build);
        JenkinsBuildInformation buildInformation = SauceOnDemandBuildAction.retrieveBuildInformationFromSauce(sauceREST, buildNumber);
        String buildId = buildInformation.getBuildId();
        if ("".equals(buildId)) {
            return jobInformation;
        }
        List<String> jobIds = SauceOnDemandBuildAction.getJobIdsForBuild(sauceREST, buildId);
        Map<String, JenkinsJobInformation> jobs = SauceOnDemandBuildAction.getJobsInformation(sauceREST, credentials, jobIds);
        for (String jobId : jobIds) {
            JenkinsJobInformation information = jobs.get(jobId);
            if (information == null) continue;
            jobInformation.put(jobId, information);
        }
        return jobInformation;
    }

    protected static List<String> getJobIdsForBuild(JenkinsSauceREST sauceREST, String buildId) {
        ArrayList<String> jobIds = new ArrayList<String>();
        LookupJobsParameters params = new LookupJobsParameters.Builder().build();
        BuildsEndpoint buildsEndpoint = sauceREST.getBuildsEndpoint();
        try {
            JobsInBuild jobsInBuild = buildsEndpoint.lookupJobsForBuild(JobSource.VDC, buildId, params);
            if (jobsInBuild == null || jobsInBuild.jobs.isEmpty()) {
                logger.log(Level.WARNING, "Build without jobs id=`" + buildId + "`");
                return jobIds;
            }
            for (JobInBuild jobInBuild : jobsInBuild.jobs) {
                jobIds.add(jobInBuild.id);
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to retrieve jobs for build " + buildId);
            return jobIds;
        }
        return jobIds;
    }

    protected static Map<String, JenkinsJobInformation> getJobsInformation(JenkinsSauceREST sauceREST, SauceCredentials credentials, Iterable<String> jobIds) throws JSONException, IOException {
        HashMap<String, JenkinsJobInformation> jobs = new HashMap<String, JenkinsJobInformation>();
        JobsEndpoint jobsEndpoint = sauceREST.getJobsEndpoint();
        List<List<String>> slicedIds = SauceOnDemandBuildAction.slice(jobIds, 20);
        for (List<String> slice : slicedIds) {
            List jobResults = jobsEndpoint.getJobDetails(slice);
            for (com.saucelabs.saucerest.model.jobs.Job job : jobResults) {
                JenkinsJobInformation information = new JenkinsJobInformation(job.id, credentials.getHMAC(job.id));
                information.populate(job);
                jobs.put(information.getJobId(), information);
            }
        }
        return jobs;
    }

    protected static List<List<String>> slice(Iterable<String> strings, int sliceSize) {
        ArrayList<List<String>> sliced = new ArrayList<List<String>>();
        ArrayList<String> current = null;
        for (String s : strings) {
            if (current == null || current.size() >= sliceSize) {
                current = new ArrayList<String>();
                sliced.add(current);
            }
            current.add(s);
        }
        return sliced;
    }

    public Run getBuild() {
        return this.build;
    }

    public boolean hasSauceOnDemandResults() {
        if (this.jobInformation == null) {
            return false;
        }
        return !this.getJobs().isEmpty();
    }

    @Exported(visibility=2)
    public JenkinsBuildInformation getSauceBuild(boolean updateBuild) {
        if (updateBuild || this.buildInformation == null) {
            String buildNumber = SauceEnvironmentUtil.getSanitizedBuildNumber(this.build);
            this.buildInformation = this.getSauceBuild(buildNumber, updateBuild);
        }
        return this.buildInformation;
    }

    @Exported(visibility=2)
    public JenkinsBuildInformation getSauceBuild() {
        return this.getSauceBuild(false);
    }

    @Exported(visibility=2)
    public JenkinsBuildInformation getSauceBuild(String sauceBuildName, boolean updateBuild) {
        if (updateBuild || this.buildInformation == null) {
            try {
                this.buildInformation = SauceOnDemandBuildAction.retrieveBuildFromSauce(this.getSauceREST(), sauceBuildName);
            }
            catch (JSONException e) {
                logger.log(Level.WARNING, "Unable to retrieve Job data from Sauce Labs", e);
            }
        }
        return this.buildInformation;
    }

    @Exported(visibility=2)
    public JenkinsBuildInformation getSauceBuild(String sauceBuildName) {
        return this.getSauceBuild(sauceBuildName, false);
    }

    @Exported(visibility=2)
    public List<JenkinsJobInformation> getJobs(boolean updateJobs) {
        if (updateJobs || this.jobInformation == null) {
            try {
                this.jobInformation = new ArrayList<JenkinsJobInformation>();
                this.jobInformation.addAll(SauceOnDemandBuildAction.retrieveJobIdsFromSauce(this.getSauceREST(), this.build, this.getCredentials()).values());
            }
            catch (IOException | JSONException e) {
                logger.log(Level.WARNING, "Unable to retrieve Job data from Sauce Labs", e);
            }
        }
        SauceCredentials credentials = this.getCredentials();
        for (JobInformation jobInformation : this.jobInformation) {
            jobInformation.setHmac(credentials.getHMAC(jobInformation.getJobId()));
        }
        return this.jobInformation;
    }

    @Override
    @Exported(visibility=2)
    public List<JenkinsJobInformation> getJobs() {
        return this.getJobs(false);
    }

    public void stopJobs() throws InterruptedException {
        JenkinsSauceREST sauceREST = this.getSauceREST();
        List<JenkinsJobInformation> jobs = this.getJobs();
        ArrayList futures = new ArrayList();
        for (JobInformation jobInformation : jobs) {
            StopJobThread worker = new StopJobThread(sauceREST, jobInformation);
            futures.add(Timer.get().submit(worker));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException x) {
                logger.log(Level.WARNING, "Could not stop a job", x);
            }
        }
    }

    public void updateJobs(Map<String, String> customDataObj) throws IOException {
        JenkinsSauceREST sauceREST = this.getSauceREST();
        JobsEndpoint jobEndpoint = sauceREST.getJobsEndpoint();
        List<JenkinsJobInformation> jobs = this.getJobs();
        for (JobInformation jobInformation : jobs) {
            jobEndpoint.addCustomData(jobInformation.getJobId(), customDataObj);
        }
    }

    @Override
    protected SauceCredentials getCredentials() {
        if (this.credentialsId != null) {
            return SauceCredentials.getCredentialsById((Item)this.build.getParent(), this.credentialsId);
        }
        if (this.build instanceof AbstractBuild) {
            return SauceCredentials.getCredentials((AbstractBuild)this.build);
        }
        return null;
    }

    public Map<String, String> getAnalytics() {
        logger.fine("Getting Sauce analytics");
        HashMap<String, String> analytics = new HashMap<String, String>();
        JenkinsBuildInformation buildInformation = this.getSauceBuild(true);
        List<JenkinsJobInformation> allJobs = this.getJobs();
        long maxJobDuration = 0L;
        long totalJobDuration = 0L;
        for (JenkinsJobInformation job : allJobs) {
            long duration = job.getDuration();
            totalJobDuration += duration;
            if (duration <= maxJobDuration) continue;
            maxJobDuration = duration;
        }
        analytics.put("start", buildInformation.getStartDate());
        analytics.put("duration", buildInformation.getPrettyDuration());
        analytics.put("efficiency", buildInformation.getEfficiency(maxJobDuration, totalJobDuration));
        analytics.put("size", String.valueOf(buildInformation.getJobsFinished()));
        analytics.put("pass", buildInformation.getJobsPassRate());
        analytics.put("fail", buildInformation.getJobsFailRate());
        analytics.put("error", buildInformation.getJobsErrorRate());
        return analytics;
    }

    protected JenkinsSauceREST getSauceREST() {
        SauceCredentials credentials = this.getCredentials();
        String username = credentials != null ? credentials.getUsername() : null;
        String accessKey = credentials != null ? credentials.getPassword().getPlainText() : null;
        String dataCenter = credentials != null ? credentials.getRestEndpointName() : null;
        DataCenter dc = DataCenter.fromString((String)dataCenter);
        return new JenkinsSauceREST(username, accessKey, dc, Jenkins.get().getProxy());
    }

    public SauceTestResultsById getById(String id) {
        return new SauceTestResultsById(id, this.getCredentials(), this.getSauceREST());
    }

    @Override
    public void doJobReport(StaplerRequest req, StaplerResponse rsp) throws IOException {
        SauceTestResultsById byId = this.getById(req.getParameter("jobId"));
        try {
            req.getView((Object)byId, "index.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
        }
        catch (ServletException e) {
            throw new IOException(e);
        }
    }

    public void setJobs(List<JenkinsJobInformation> jobs) {
        this.jobInformation = jobs;
    }

    protected Object readResolve() {
        if (this.credentialsId == null && this.build.getParent() instanceof BuildableItemWithBuildWrappers) {
            BuildableItemWithBuildWrappers p = (BuildableItemWithBuildWrappers)this.build.getParent();
            SauceOnDemandBuildWrapper bw = (SauceOnDemandBuildWrapper)p.getBuildWrappersList().get(SauceOnDemandBuildWrapper.class);
            this.credentialsId = bw.getCredentialId();
        }
        return this;
    }

    public Collection<? extends Action> getProjectActions() {
        Job job = this.build.getParent();
        if (!Util.filter((List)job.getActions(), SauceOnDemandProjectAction.class).isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.singleton(new SauceOnDemandProjectAction(job));
    }

    public void onAttached(Run<?, ?> run) {
        this.build = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.build = run;
    }
}

