/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sauce_ondemand;

import com.saucelabs.ci.Browser;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.maven.MavenBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildableItemWithBuildWrappers;
import hudson.model.Run;
import hudson.plugins.sauce_ondemand.PluginImpl;
import hudson.plugins.sauce_ondemand.SauceOnDemandBuildWrapper;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;

public final class SauceEnvironmentUtil {
    private static final Logger logger = Logger.getLogger(SauceEnvironmentUtil.class.getName());
    private static final String PATTERN_DISALLOWED_CHARS = "[^\\w\\d-]+";

    private SauceEnvironmentUtil() {
    }

    public static void outputVariables(Map<String, String> env, List<Browser> browsers, String userName, String apiKey, boolean verboseLogging, PrintStream logger) {
        if (browsers != null && !browsers.isEmpty()) {
            if (browsers.size() == 1) {
                Browser browserInstance = browsers.get(0);
                SauceEnvironmentUtil.outputEnvironmentVariablesForBrowser(env, browserInstance, userName, apiKey, verboseLogging, logger);
            }
            JSONArray browsersJSON = new JSONArray();
            for (Browser browserInstance : browsers) {
                SauceEnvironmentUtil.browserAsJSON(browsersJSON, browserInstance, userName, apiKey);
                SauceEnvironmentUtil.outputEnvironmentVariable(env, "SELENIUM_DRIVER", browserInstance.getUri(userName, apiKey), verboseLogging, logger);
            }
            SauceEnvironmentUtil.outputEnvironmentVariable(env, "SAUCE_ONDEMAND_BROWSERS", browsersJSON.toString(), verboseLogging, logger);
        }
    }

    public static void browserAsJSON(JSONArray browsersJSON, Browser browserInstance, String userName, String apiKey) {
        if (browserInstance == null) {
            return;
        }
        JSONObject config = new JSONObject();
        try {
            config.put("os", (Object)browserInstance.getOs());
            config.put("platform", (Object)browserInstance.getPlatform().toString());
            config.put("browser", (Object)browserInstance.getBrowserName());
            config.put("browser-version", (Object)browserInstance.getVersion());
            config.put("long-name", (Object)browserInstance.getLongName());
            config.put("long-version", (Object)browserInstance.getLongVersion());
            config.put("url", (Object)browserInstance.getUri(userName, apiKey));
            if (browserInstance.getDevice() != null) {
                config.put("device", (Object)browserInstance.getDevice());
            }
            if (browserInstance.getDeviceType() != null) {
                config.put("device-type", (Object)browserInstance.getDeviceType());
            }
            if (browserInstance.getDeviceOrientation() != null) {
                config.put("device-orientation", (Object)browserInstance.getDeviceOrientation());
            }
        }
        catch (JSONException e) {
            logger.log(Level.SEVERE, "Unable to create JSON Object", e);
        }
        browsersJSON.add((Object)config);
    }

    public static void outputEnvironmentVariablesForBrowser(Map<String, String> env, Browser browserInstance, String userName, String apiKey, boolean verboseLogging, PrintStream printStream) {
        SauceEnvironmentUtil.outputEnvironmentVariablesForBrowser(env, browserInstance, userName, apiKey, false, verboseLogging, printStream);
    }

    public static void outputEnvironmentVariablesForBrowser(Map<String, String> env, Browser browserInstance, String userName, String apiKey, boolean overwrite, boolean verboseLogging, PrintStream printStream) {
        if (browserInstance != null) {
            SauceEnvironmentUtil.outputEnvironmentVariable(env, "SELENIUM_PLATFORM", browserInstance.getOs(), overwrite, verboseLogging, printStream);
            SauceEnvironmentUtil.outputEnvironmentVariable(env, "SELENIUM_BROWSER", browserInstance.getBrowserName(), overwrite, verboseLogging, printStream);
            SauceEnvironmentUtil.outputEnvironmentVariable(env, "SELENIUM_VERSION", browserInstance.getVersion(), overwrite, verboseLogging, printStream);
            SauceEnvironmentUtil.outputEnvironmentVariable(env, "SELENIUM_DRIVER", browserInstance.getUri(userName, apiKey), overwrite, verboseLogging, printStream);
            if (browserInstance.getDevice() != null) {
                SauceEnvironmentUtil.outputEnvironmentVariable(env, "SELENIUM_DEVICE", browserInstance.getDevice(), overwrite, verboseLogging, printStream);
            }
            if (browserInstance.getDeviceType() != null) {
                SauceEnvironmentUtil.outputEnvironmentVariable(env, "SELENIUM_DEVICE_TYPE", browserInstance.getDeviceType(), overwrite, verboseLogging, printStream);
            }
            if (browserInstance.getDeviceOrientation() != null) {
                SauceEnvironmentUtil.outputEnvironmentVariable(env, "SELENIUM_DEVICE_ORIENTATION", browserInstance.getDeviceOrientation(), overwrite, verboseLogging, printStream);
            }
        }
    }

    public static void outputEnvironmentVariable(Map<String, String> env, String key, String value, boolean verboseLogging, PrintStream printStream) {
        SauceEnvironmentUtil.outputEnvironmentVariable(env, key, value, false, verboseLogging, printStream);
    }

    public static void outputEnvironmentVariable(Map<String, String> env, String key, String value, boolean overwrite, boolean verboseLogging, PrintStream printStream) {
        if (env.get(key) == null || overwrite) {
            PluginImpl pluginImpl = PluginImpl.get();
            String environmentVariablePrefix = "";
            if (pluginImpl != null && (environmentVariablePrefix = pluginImpl.getEnvironmentVariablePrefix()) == null) {
                environmentVariablePrefix = "";
            }
            env.put(environmentVariablePrefix + key, value);
            if (verboseLogging) {
                printStream.println(environmentVariablePrefix + key + ": " + value);
            }
        }
    }

    public static SauceOnDemandBuildWrapper getBuildWrapper(AbstractProject<?, ?> project) {
        SauceOnDemandBuildWrapper buildWrapper = null;
        if (project instanceof BuildableItemWithBuildWrappers) {
            buildWrapper = (SauceOnDemandBuildWrapper)((BuildableItemWithBuildWrappers)project).getBuildWrappersList().get(SauceOnDemandBuildWrapper.class);
        } else {
            logger.fine("Project is not a BuildableItemWithBuildWrappers instance " + project.toString());
        }
        if (buildWrapper == null) {
            logger.fine("Could not find SauceOnDemandBuildWrapper on project " + project.toString());
        }
        return buildWrapper;
    }

    @NonNull
    public static String getBuildName(Run<?, ?> build) {
        while (build != null && build instanceof MavenBuild && ((MavenBuild)build).getParentBuild() != null) {
            build = ((MavenBuild)build).getParentBuild();
        }
        if (build == null) {
            return "";
        }
        String displayName = build.getFullDisplayName();
        String buildName = build.getDisplayName();
        StringBuilder builder = new StringBuilder(displayName);
        if (StringUtils.countMatches((String)displayName, (String)buildName) > 1) {
            builder.replace(displayName.lastIndexOf(buildName), displayName.length(), "#" + build.getNumber());
        }
        return builder.toString();
    }

    public static String generateTunnelName(String projectName, int buildNumber) {
        String sanitizedName = projectName.replaceAll(PATTERN_DISALLOWED_CHARS, "_");
        return sanitizedName + "-" + buildNumber + "-" + System.currentTimeMillis();
    }

    public static String getSanitizedBuildNumber(Run run) {
        return "jenkins-" + SauceEnvironmentUtil.getBuildName(run).replaceAll(PATTERN_DISALLOWED_CHARS, "-");
    }
}

