/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sauce_ondemand;

import com.saucelabs.saucerest.DataCenter;
import com.saucelabs.saucerest.SauceREST;
import com.saucelabs.saucerest.api.HttpClientConfig;
import hudson.ProxyConfiguration;
import hudson.plugins.sauce_ondemand.BuildUtils;
import hudson.plugins.sauce_ondemand.ProxyAuthenticator;
import hudson.plugins.sauce_ondemand.UserAgentInterceptor;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Objects;
import jenkins.model.Jenkins;
import okhttp3.Authenticator;
import okhttp3.Interceptor;

public class JenkinsSauceREST
extends SauceREST {
    protected static final String userAgent = "Jenkins/" + Jenkins.VERSION + " JenkinsSauceOnDemand/" + BuildUtils.getCurrentVersion();
    private String server = JenkinsSauceREST.getSauceRestUrlFromEnv();

    public JenkinsSauceREST(String username, String accessKey, DataCenter dataCenter, ProxyConfiguration proxy) {
        super(username, accessKey, dataCenter, JenkinsSauceREST.getJenkinsPluginHttpConfig(dataCenter, proxy));
        if (this.server == null) {
            this.server = dataCenter.server();
        }
    }

    private static String getSauceRestUrlFromEnv() {
        String srUrl = System.getenv("SAUCE_REST_ENDPOINT");
        if (srUrl == null) {
            return System.getProperty("saucerest-java.base_url");
        }
        return srUrl;
    }

    private static HttpClientConfig getJenkinsPluginHttpConfig(DataCenter dataCenter, ProxyConfiguration proxyConfig) {
        String server = JenkinsSauceREST.getSauceRestUrlFromEnv();
        if (server == null) {
            server = dataCenter.server();
        }
        Proxy proxy = null;
        Authenticator auth = Authenticator.NONE;
        if (proxyConfig != null) {
            String host = Objects.requireNonNull(JenkinsSauceREST.buildURL(server)).getHost();
            proxy = proxyConfig.createProxy(host);
            if (proxyConfig.getUserName() != null && !proxyConfig.getUserName().isEmpty() && proxyConfig.getSecretPassword() != null && !proxyConfig.getSecretPassword().getPlainText().isEmpty()) {
                auth = new ProxyAuthenticator(proxyConfig.getUserName(), proxyConfig.getSecretPassword().getPlainText());
            }
        }
        UserAgentInterceptor ua = new UserAgentInterceptor(userAgent);
        return HttpClientConfig.defaultConfig().proxy(proxy).authenticator(auth).interceptor((Interceptor)ua);
    }

    protected static URL buildURL(String server) {
        try {
            return new URL(new URL(server), "/rest/v1/");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public void setServer(String server) {
        if (server != null && !server.isEmpty()) {
            this.server = server;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JenkinsSauceREST)) {
            return super.equals(obj);
        }
        JenkinsSauceREST sauceobj = (JenkinsSauceREST)((Object)obj);
        return Objects.equals(sauceobj.username, this.username) && Objects.equals(sauceobj.accessKey, this.accessKey) && Objects.equals(sauceobj.server, this.server);
    }

    public int hashCode() {
        return Objects.hash(this.server, this.username, this.accessKey);
    }
}

