/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sauce_ondemand;

import com.saucelabs.ci.Browser;
import hudson.Extension;
import hudson.matrix.AxisDescriptor;
import hudson.plugins.sauce_ondemand.BrowserAxis;
import hudson.plugins.sauce_ondemand.WebDriverAxis;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.kohsuke.stapler.DataBoundConstructor;

public class AppiumAxis
extends BrowserAxis {
    private static final Logger logger = Logger.getLogger(WebDriverAxis.class.getName());

    @DataBoundConstructor
    public AppiumAxis(List<String> values) {
        super(values);
    }

    @Override
    protected Browser getBrowserForKey(String value) {
        return BROWSER_FACTORY.appiumBrowserForKey(value);
    }

    @Extension
    public static class DescriptorImpl
    extends AxisDescriptor {
        public String getDisplayName() {
            return "Sauce Labs Appium tests";
        }

        public List<Browser> getBrowsers() {
            try {
                return BrowserAxis.BROWSER_FACTORY.getAppiumBrowsers();
            }
            catch (JSONException e) {
                logger.log(Level.WARNING, "Error parsing JSON response", e);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error retrieving response", e);
            }
            return Collections.emptyList();
        }
    }
}

