/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.jenkins.pipeline;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.google.common.util.concurrent.FutureCallback;
import com.saucelabs.jenkins.pipeline.ExpanderImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.plugins.sauce_ondemand.SauceEnvironmentUtil;
import hudson.plugins.sauce_ondemand.SauceOnDemandBuildAction;
import hudson.plugins.sauce_ondemand.credentials.SauceCredentials;
import hudson.util.ListBoxModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.BodyExecution;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class SauceStep
extends Step {
    private final String credentialsId;

    @DataBoundConstructor
    public SauceStep(String credentialsId) {
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(context, this.credentialsId);
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(Run.class);
        }

        public String getDisplayName() {
            return "Sauce";
        }

        public String getFunctionName() {
            return "sauce";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Set<Class<?>> getProvidedContext() {
            return Collections.singleton(SauceCredentials.class);
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project) {
            return new StandardUsernameListBoxModel().withAll(SauceCredentials.all(project));
        }
    }

    public static class Execution
    extends StepExecution {
        private static final long serialVersionUID = 1L;
        private final String credentialsId;
        private BodyExecution body;

        public Execution(@NonNull StepContext context, String credentialsId) {
            super(context);
            this.credentialsId = credentialsId;
        }

        public boolean start() throws Exception {
            Run run = (Run)this.getContext().get(Run.class);
            Job job = run.getParent();
            if (!(job instanceof TopLevelItem)) {
                throw new Exception(job + " must be a top-level job");
            }
            SauceCredentials credentials = SauceCredentials.getCredentialsById((Item)job, this.credentialsId);
            if (credentials == null) {
                throw new Exception("no credentials provided");
            }
            CredentialsProvider.track((Run)run, (Credentials)credentials);
            HashMap<String, String> overrides = new HashMap<String, String>();
            overrides.put("SAUCE_USERNAME", credentials.getUsername());
            overrides.put("SAUCE_ACCESS_KEY", credentials.getPassword().getPlainText());
            overrides.put("SAUCE_REST_ENDPOINT", credentials.getRestEndpoint());
            overrides.put("JENKINS_BUILD_NUMBER", SauceEnvironmentUtil.getSanitizedBuildNumber(run));
            overrides.put("SAUCE_BUILD_NAME", SauceEnvironmentUtil.getSanitizedBuildNumber(run));
            SauceOnDemandBuildAction buildAction = (SauceOnDemandBuildAction)run.getAction(SauceOnDemandBuildAction.class);
            if (buildAction == null) {
                buildAction = new SauceOnDemandBuildAction(run, credentials.getId());
                run.addAction((Action)buildAction);
            }
            this.body = this.getContext().newBodyInvoker().withContext((Object)credentials).withContext((Object)EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)new ExpanderImpl(overrides))).withCallback(BodyExecutionCallback.wrap((FutureCallback)this.getContext())).start();
            return false;
        }

        public void stop(@NonNull Throwable cause) throws Exception {
            if (this.body != null) {
                this.body.cancel(cause);
            }
        }
    }
}

