/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.jenkins.pipeline;

import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.saucelabs.ci.sauceconnect.AbstractSauceTunnelManager;
import com.saucelabs.ci.sauceconnect.SauceConnectManager;
import com.saucelabs.jenkins.HudsonSauceManagerFactory;
import com.saucelabs.jenkins.pipeline.ExpanderImpl;
import com.saucelabs.saucerest.DataCenter;
import com.saucelabs.saucerest.SauceREST;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.plugins.sauce_ondemand.PluginImpl;
import hudson.plugins.sauce_ondemand.SauceEnvironmentUtil;
import hudson.plugins.sauce_ondemand.SauceOnDemandBuildWrapper;
import hudson.plugins.sauce_ondemand.credentials.SauceCredentials;
import hudson.remoting.Callable;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.BodyExecution;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SauceConnectStep
extends Step {
    private Boolean verboseLogging = false;
    private Boolean useLatestSauceConnect = false;
    private Boolean useGeneratedTunnelIdentifier = false;
    private String options;
    private String optionsSC5;
    private String sauceConnectPath;

    @DataBoundConstructor
    public SauceConnectStep() {
    }

    public SauceConnectStep(String options, String optionsSC5, Boolean verboseLogging, Boolean useLatestSauceConnect, Boolean useGeneratedTunnelIdentifier, String sauceConnectPath) {
        this.verboseLogging = verboseLogging;
        this.useLatestSauceConnect = useLatestSauceConnect;
        this.useGeneratedTunnelIdentifier = useGeneratedTunnelIdentifier;
        this.sauceConnectPath = Util.fixEmptyAndTrim((String)sauceConnectPath);
        this.options = StringUtils.trimToEmpty((String)options);
        this.optionsSC5 = StringUtils.trimToEmpty((String)optionsSC5);
    }

    public StepExecution start(StepContext context) throws Exception {
        return new SauceConnectStepExecution(context, PluginImpl.get().getSauceConnectOptions(), this.options, this.optionsSC5, this.useGeneratedTunnelIdentifier, this.verboseLogging, this.sauceConnectPath, this.useLatestSauceConnect, Jenkins.get().getProxy());
    }

    public String getOptions() {
        return this.options;
    }

    @DataBoundSetter
    public void setOptions(String options) {
        this.options = options.strip();
    }

    public String getOptionsSC5() {
        return this.optionsSC5;
    }

    @DataBoundSetter
    public void setOptionsSC5(String optionsSC5) {
        this.optionsSC5 = optionsSC5.strip();
    }

    public String getSauceConnectPath() {
        return this.sauceConnectPath;
    }

    @DataBoundSetter
    public void setSauceConnectPath(String sauceConnectPath) {
        this.sauceConnectPath = sauceConnectPath;
    }

    public Boolean getUseGeneratedTunnelIdentifier() {
        return this.useGeneratedTunnelIdentifier;
    }

    @DataBoundSetter
    public void setUseGeneratedTunnelIdentifier(Boolean useGeneratedTunnelIdentifier) {
        this.useGeneratedTunnelIdentifier = useGeneratedTunnelIdentifier;
    }

    public Boolean getUseLatestSauceConnect() {
        return this.useLatestSauceConnect;
    }

    public Boolean getVerboseLogging() {
        return this.verboseLogging;
    }

    @DataBoundSetter
    public void setVerboseLogging(Boolean verboseLogging) {
        this.verboseLogging = verboseLogging;
    }

    public static class SauceConnectStepExecution
    extends StepExecution {
        private final String globalOptions;
        private final String options;
        private final String optionsSC5;
        private final boolean useGeneratedTunnelIdentifier;
        private final boolean verboseLogging;
        private final String sauceConnectPath;
        private final boolean useLatestSauceConnect;
        private static final long serialVersionUID = 1L;
        private final ProxyConfiguration proxy;
        private BodyExecution body;

        public SauceConnectStepExecution(@NonNull StepContext context, String globalOptions, String options, String optionsSC5, boolean useGeneratedTunnelIdentifier, boolean verboseLogging, String sauceConnectPath, boolean useLatestSauceConnect, ProxyConfiguration proxy) {
            super(context);
            this.globalOptions = globalOptions;
            this.options = options;
            this.optionsSC5 = optionsSC5;
            this.useGeneratedTunnelIdentifier = useGeneratedTunnelIdentifier;
            this.verboseLogging = verboseLogging;
            this.sauceConnectPath = sauceConnectPath;
            this.useLatestSauceConnect = useLatestSauceConnect;
            this.proxy = proxy;
        }

        public boolean start() throws Exception {
            Run run;
            Job job;
            boolean legacyCLI = false;
            if (this.options != null && this.optionsSC5 != null && !this.options.isEmpty() && !this.optionsSC5.isEmpty()) {
                throw new Exception("Legacy and SC5 CLI options cannot both be specified");
            }
            if (this.options != null && !this.options.isEmpty()) {
                legacyCLI = true;
            }
            if (!((job = (run = (Run)this.getContext().get(Run.class)).getParent()) instanceof TopLevelItem)) {
                throw new Exception(job + " must be a top-level job");
            }
            Computer computer = (Computer)this.getContext().get(Computer.class);
            Node node = computer.getNode();
            if (node == null) {
                throw new Exception("computer does not correspond to a live node");
            }
            int port = (Integer)computer.getChannel().call((Callable)new SauceOnDemandBuildWrapper.GetAvailablePort());
            ArrayList<String> optionsArray = new ArrayList<String>();
            optionsArray.add(this.globalOptions);
            if (legacyCLI) {
                optionsArray.add(this.options);
            } else {
                optionsArray.add(this.optionsSC5);
            }
            optionsArray.removeAll(Collections.singleton(""));
            Object combinedOptions = StringUtils.join(optionsArray, (String)" ");
            HashMap<String, String> overrides = new HashMap<String, String>();
            overrides.put("SELENIUM_PORT", String.valueOf(port));
            overrides.put("SELENIUM_HOST", "localhost");
            if (this.useGeneratedTunnelIdentifier) {
                String tunnelName = SauceEnvironmentUtil.generateTunnelName(job.getName(), run.number);
                overrides.put("TUNNEL_NAME", tunnelName);
                combinedOptions = (String)combinedOptions + " --tunnel-name " + tunnelName;
            }
            SauceCredentials sauceCredentials = (SauceCredentials)((Object)this.getContext().get(SauceCredentials.class));
            String region = sauceCredentials.getRegion();
            combinedOptions = (String)combinedOptions + " --region " + region;
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            listener.getLogger().println("Starting sauce connect");
            SauceStartConnectHandler handler = new SauceStartConnectHandler(sauceCredentials, port, (String)combinedOptions, listener, this.verboseLogging, this.sauceConnectPath, this.useLatestSauceConnect, legacyCLI, this.proxy);
            computer.getChannel().call((Callable)handler);
            this.body = this.getContext().newBodyInvoker().withContext((Object)EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)new ExpanderImpl(overrides))).withCallback((BodyExecutionCallback)new Callback(sauceCredentials, this.options, this.proxy)).withDisplayName("Sauce Connect").start();
            return false;
        }

        public void stop(@NonNull Throwable cause) throws Exception {
            if (this.body != null) {
                this.body.cancel(cause);
            }
        }

        public static SauceConnectManager getSauceTunnelManager() {
            return HudsonSauceManagerFactory.getInstance().createSauceConnectManager();
        }

        private static final class Callback
        extends BodyExecutionCallback.TailCall {
            private final String options;
            private final SauceCredentials sauceCredentials;
            private final ProxyConfiguration proxy;

            Callback(SauceCredentials sauceCredentials, String options, ProxyConfiguration proxy) {
                this.sauceCredentials = sauceCredentials;
                this.options = options;
                this.proxy = proxy;
            }

            protected void finished(StepContext context) throws Exception {
                TaskListener listener = (TaskListener)context.get(TaskListener.class);
                Computer computer = (Computer)context.get(Computer.class);
                SauceStopConnectHandler stopConnectHandler = new SauceStopConnectHandler(this.sauceCredentials, this.options, listener, this.proxy);
                computer.getChannel().call((Callable)stopConnectHandler);
            }
        }
    }

    private static final class SauceStopConnectHandler
    extends MasterToSlaveCallable<Void, AbstractSauceTunnelManager.SauceConnectException> {
        private final SauceCredentials sauceCredentials;
        private final String options;
        private final TaskListener listener;
        private final ProxyConfiguration proxy;

        SauceStopConnectHandler(SauceCredentials sauceCredentials, String options, TaskListener listener, ProxyConfiguration proxy) {
            this.sauceCredentials = sauceCredentials;
            this.options = options;
            this.listener = listener;
            this.proxy = proxy;
        }

        public Void call() throws AbstractSauceTunnelManager.SauceConnectException {
            SauceConnectManager sauceTunnelManager = SauceConnectStepExecution.getSauceTunnelManager();
            sauceTunnelManager.setSauceRest((SauceREST)this.sauceCredentials.getSauceREST(this.proxy));
            sauceTunnelManager.closeTunnelsForPlan(this.sauceCredentials.getUsername(), this.options, this.listener.getLogger());
            return null;
        }
    }

    private static final class SauceStartConnectHandler
    extends MasterToSlaveCallable<Void, AbstractSauceTunnelManager.SauceConnectException> {
        private final SauceCredentials sauceCredentials;
        private final int port;
        private final String options;
        private final TaskListener listener;
        private final Boolean verboseLogging;
        private final String sauceConnectPath;
        private final Boolean useLatestSauceConnect;
        private final Boolean legacyCLI;
        private final ProxyConfiguration proxy;

        SauceStartConnectHandler(SauceCredentials sauceCredentials, int port, String options, TaskListener listener, Boolean verboseLogging, String sauceConnectPath, Boolean useLatestSauceConnect, Boolean legacyCLI, ProxyConfiguration proxy) {
            this.sauceCredentials = sauceCredentials;
            this.port = port;
            this.options = options.strip();
            this.listener = listener;
            this.verboseLogging = verboseLogging;
            this.sauceConnectPath = sauceConnectPath;
            this.useLatestSauceConnect = useLatestSauceConnect;
            this.legacyCLI = legacyCLI;
            this.proxy = proxy;
        }

        public Void call() throws AbstractSauceTunnelManager.SauceConnectException {
            SauceConnectManager sauceTunnelManager = SauceConnectStepExecution.getSauceTunnelManager();
            sauceTunnelManager.setSauceRest((SauceREST)this.sauceCredentials.getSauceREST(this.proxy));
            sauceTunnelManager.setUseLatestSauceConnect(this.useLatestSauceConnect.booleanValue());
            sauceTunnelManager.openConnection(this.sauceCredentials.getUsername(), this.sauceCredentials.getApiKey().getPlainText(), DataCenter.fromString((String)this.sauceCredentials.getRestEndpointName()), this.port, null, this.options, this.listener.getLogger(), this.verboseLogging, this.sauceConnectPath, this.legacyCLI.booleanValue());
            return null;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getDisplayName() {
            return "Sauce Connect";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            HashSet context = new HashSet();
            Collections.addAll(context, Run.class, Computer.class, TaskListener.class, SauceCredentials.class);
            return Collections.unmodifiableSet(context);
        }

        public String getFunctionName() {
            return "sauceconnect";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project) {
            return new StandardUsernameListBoxModel().withAll(SauceCredentials.all(project));
        }
    }
}

